/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityControllerIO;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockControllerIO
extends Block
implements INetworked,
EntityBlock,
IFramedSourceBlock {
    public BlockControllerIO(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockController getController(Level world, BlockPos pos) {
        BlockEntityControllerIO blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityControllerIO.class);
        if (blockEntity == null) {
            return null;
        }
        BlockPos controllerPos = blockEntity.getControllerPos();
        if (controllerPos == null) {
            return null;
        }
        Block block = world.getBlockState(controllerPos).getBlock();
        if (block instanceof BlockController) {
            BlockController c = (BlockController)block;
            return c;
        }
        return null;
    }

    public BlockEntityControllerIO newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityControllerIO)ModServices.RESOURCE_FACTORY.createBlockEntityControllerIO().create(pos, state);
    }

    @Override
    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        return FrameHelper.makeFramedItem((IFramedBlock)ModBlocks.FRAMED_CONTROLLER_IO.get(), source, matSide, matTrim, matFront);
    }
}

