/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.annotations.Since;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import journeymap.api.v2.client.display.Displayable;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class WaypointIcon {
    public static final ResourceLocation DEFAULT_ICON_NORMAL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"textures/waypoint/icon/waypoint-icon.png");
    public static final ResourceLocation DEFAULT_ICON_DEATH = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"textures/waypoint/icon/waypoint-death-icon.png");
    public static MapCodec<WaypointIcon> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("resourceLocation").forGetter(WaypointIcon::getResourceLocation), (App)Codec.INT.optionalFieldOf("rotation").forGetter(icon -> Optional.ofNullable(icon.getRotation())), (App)Codec.INT.optionalFieldOf("textureWidth").forGetter(icon -> Optional.ofNullable(icon.getTextureWidth())), (App)Codec.INT.optionalFieldOf("textureHeight").forGetter(icon -> Optional.ofNullable(icon.getTextureHeight())), (App)Codec.INT.optionalFieldOf("color").forGetter(icon -> Optional.ofNullable(icon.getColor())), (App)Codec.FLOAT.optionalFieldOf("opacity").forGetter(icon -> Optional.ofNullable(Float.valueOf(icon.getOpacity())))).apply((Applicative)instance, (loc, rot, width, height, color, opacity) -> {
        if (loc.getPath().contains("ui/img")) {
            loc = loc.withPath(loc.getPath().replace("ui/img", "textures/waypoint/icon"));
        }
        return new WaypointIcon((ResourceLocation)loc, (Optional<Integer>)rot, (Optional<Integer>)width, (Optional<Integer>)height, (Optional<Integer>)color, (Optional<Float>)opacity);
    }));
    public transient boolean dirty;
    @Since(value=1.0)
    private String resourceLocation;
    @Since(value=1.0)
    private Integer color;
    @Since(value=1.0)
    private Float opacity = Float.valueOf(1.0f);
    @Since(value=1.0)
    private Integer textureWidth = 16;
    @Since(value=1.0)
    private Integer textureHeight = 16;
    @Since(value=1.0)
    private Integer rotation = 0;

    public WaypointIcon() {
        this.resourceLocation = DEFAULT_ICON_NORMAL.toString();
    }

    public WaypointIcon(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation.toString();
        this.opacity = Float.valueOf(1.0f);
    }

    public WaypointIcon(ResourceLocation resourceLocation, int textureWidth, int textureHeight) {
        this(resourceLocation, textureWidth, textureHeight, -1, 1.0f);
    }

    public WaypointIcon(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int color, float opacity) {
        this.resourceLocation = resourceLocation.toString();
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.color = color;
        this.opacity = Float.valueOf(opacity);
    }

    @ApiStatus.Internal
    public WaypointIcon(ResourceLocation resourceLocation, Optional<Integer> rotation, Optional<Integer> textureWidth, Optional<Integer> textureHeight, Optional<Integer> color, Optional<Float> opacity) {
        this.resourceLocation = resourceLocation.toString();
        rotation.ifPresent(val -> {
            this.rotation = val;
        });
        color.ifPresent(val -> {
            this.color = val;
        });
        opacity.ifPresent(val -> {
            this.opacity = val;
        });
        textureHeight.ifPresent(val -> {
            this.textureHeight = val;
        });
        textureWidth.ifPresent(val -> {
            this.textureWidth = val;
        });
    }

    public WaypointIcon(WaypointIcon original) {
        this.resourceLocation = original.getResourceLocation().toString();
        this.textureWidth = original.getTextureWidth();
        this.textureHeight = original.getTextureHeight();
        this.color = original.getColor();
        this.opacity = Float.valueOf(original.getOpacity());
        this.rotation = original.getRotation();
        this.markDirty();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation % 360;
        this.markDirty();
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color != null ? Integer.valueOf(Displayable.clampRGB((int)color)) : null;
        this.markDirty();
    }

    public boolean useBeaconColor() {
        return this.color == null;
    }

    public float getOpacity() {
        return this.opacity.floatValue();
    }

    public void setOpacity(float opacity) {
        this.opacity = Float.valueOf(Displayable.clampOpacity((float)opacity));
        this.markDirty();
    }

    public ResourceLocation getResourceLocation() {
        return ResourceLocation.tryParse((String)this.resourceLocation);
    }

    public void setResourceLoctaion(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation.toString();
        this.markDirty();
    }

    public Integer getTextureWidth() {
        return this.textureWidth;
    }

    public Integer getTextureHeight() {
        return this.textureHeight;
    }

    public void setTextureWidth(Integer textureWidth) {
        this.textureWidth = Math.max(1, textureWidth);
        this.markDirty();
    }

    public void setTextureHeight(Integer textureHeight) {
        this.textureHeight = Math.max(1, textureHeight);
        this.markDirty();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointIcon mapImage = (WaypointIcon)o;
        return Objects.equal((Object)this.color, (Object)mapImage.color) && Objects.equal((Object)this.opacity, (Object)mapImage.opacity) && Objects.equal((Object)this.textureWidth, (Object)mapImage.textureWidth) && Objects.equal((Object)this.textureHeight, (Object)mapImage.textureHeight) && Objects.equal((Object)this.resourceLocation, (Object)mapImage.resourceLocation);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceLocation, this.color, this.opacity, this.textureWidth, this.textureHeight});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("imageLocation", (Object)this.resourceLocation).add("color", (Object)this.color).add("textureHeight", (Object)this.textureHeight).add("opacity", (Object)this.opacity).add("textureWidth", (Object)this.textureWidth).toString();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void markDirty() {
        this.setDirty(true);
    }
}

