/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.awt.Color;
import java.util.Collection;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.util.PermissionsManager;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CreateWaypoint {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode waypoint = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"waypoint").requires(CreateWaypoint::canUseCommand)).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"color", (ArgumentType)ColorArgument.color()).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), ColorArgument.getColor((CommandContext)ctx, (String)"color"), false))).then(Commands.argument((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), ColorArgument.getColor((CommandContext)ctx, (String)"color"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce"))))))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> CreateWaypoint.deleteWaypoint(EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))).then(Commands.argument((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.deleteWaypoint(EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wp").requires(CreateWaypoint::canUseCommand)).redirect((CommandNode)waypoint));
    }

    private static boolean canUseCommand(CommandSourceStack ctx) {
        try {
            return ctx.hasPermission(2) || ctx.getEntity() != null && ctx.isPlayer() && PermissionsManager.getInstance().canServerAdmin((ServerPlayer)ctx.getEntity()) || !ctx.getServer().isDedicatedServer();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int deleteWaypoint(Collection<ServerPlayer> players, String name, boolean announce) {
        WaypointImpl ext = new WaypointImpl(name, "null");
        CreateWaypoint.sendPacket(players, ext, "delete", announce);
        return 1;
    }

    private static int createWaypoint(CommandSourceStack source, Collection<ServerPlayer> players, String name, ServerLevel dimension, Coordinates location, ChatFormatting textFormatting, boolean announce) {
        try {
            Waypoint waypoint = WaypointFactoryImpl.createCommandWaypoint("journeymap", location.getBlockPos(source), name, dimension.dimension().location().toString(), false, false, new Color(textFormatting.getColor()).getRGB(), true);
            CreateWaypoint.sendPacket(players, new WaypointImpl((WaypointImpl)waypoint), "create", announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error creating waypoint from command.", t);
        }
        return 1;
    }

    private static void sendPacket(Collection<ServerPlayer> players, WaypointImpl wp, String action, boolean announce) {
        wp.setOrigin("command");
        players.forEach(player -> Journeymap.getInstance().getDispatcher().sendWaypointPacket((ServerPlayer)player, wp.toString(), announce, action));
    }
}

