/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.util.Objects;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.log.ChatLog;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class AutoMapConfirmation
extends JmUILegacy {
    Button buttonOptions;
    Button buttonAll;
    Button buttonMissing;
    Button buttonClose;

    public AutoMapConfirmation() {
        this((Screen)null);
    }

    public AutoMapConfirmation(Screen returnDisplay) {
        super(Constants.getString("jm.common.automap_dialog"), returnDisplay);
    }

    @Override
    public void init() {
        this.getRenderables().clear();
        super.setRenderBottomBar(true);
        this.buttonOptions = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager((Screen)this, ClientCategory.Cartography)));
        this.buttonAll = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.automap_dialog_all"), button -> this.initAutoMapping(true, Boolean.TRUE)));
        this.buttonMissing = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.automap_dialog_missing"), button -> this.initAutoMapping(true, Boolean.FALSE)));
        this.buttonClose = (Button)this.addRenderableWidget((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonAll.setDefaultStyle(false);
        this.buttonMissing.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.getRenderables().add((Renderable)this.buttonOptions);
        this.getRenderables().add((Renderable)this.buttonAll);
        this.getRenderables().add((Renderable)this.buttonMissing);
        this.getRenderables().add((Renderable)this.buttonClose);
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics) {
        if (this.getRenderables().isEmpty()) {
            this.init();
        }
        int x = this.width / 2;
        Objects.requireNonNull(this.font);
        int lineHeight = 9 + 3;
        int y = 36 + lineHeight * 2;
        graphics.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_1"), x, y, 0xFFFFFF);
        graphics.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_summary_2"), x, y += lineHeight, 0xFFFFFF);
        this.buttonOptions.centerHorizontalOn(x).centerVerticalOn(y += lineHeight * 2);
        y += lineHeight * 3;
        if (Services.COMMON_SERVICE.isModLoaded("c2me")) {
            String text1 = Constants.getString("jm.common.automap_dialog_warning_1", "C2ME");
            String text2 = Constants.getString("jm.common.automap_dialog_warning_2", "c2me");
            int y1 = y - lineHeight;
            int x2 = x - this.font.width(text2) / 2;
            graphics.fill(x2 - 2, y1 - lineHeight - 2, x2 + this.font.width(text2) + 2, y - lineHeight + 9 + 2, RGB.toArgb(0x404040, 0.85f));
            graphics.drawCenteredString(this.getFontRenderer(), text1, x, y1 - lineHeight, 0xFF0000);
            graphics.drawCenteredString(this.getFontRenderer(), text2, x, y1, 0xFF0000);
        }
        graphics.drawCenteredString(this.getFontRenderer(), Constants.getString("jm.common.automap_dialog_text"), x, y, 0xFFFF00);
        ButtonList buttons = new ButtonList(this.buttonAll, this.buttonMissing);
        buttons.equalizeWidths(this.font, 4, 200);
        buttons.layoutCenteredHorizontal(x, y += lineHeight * 2, true, 4);
        this.buttonClose.centerHorizontalOn(x).below(this.buttonMissing, lineHeight);
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        Boolean value;
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        if (arg instanceof Boolean && !(value = (Boolean)arg).booleanValue()) {
            ChatLog.announceI18N("jm.common.automap_missing_start", new Object[0]);
        }
        JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.closeAndReturn();
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }
}

