/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;

public abstract class ColoredImageWidget
extends AbstractWidget {
    ColoredImageWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
    }

    public static ColoredImageWidget texture(int width, int height, DynamicTexture texture, int textureWidth, int textureHeight, int color, boolean blur) {
        return new Image(0, 0, width, height, texture, textureWidth, textureHeight, color, blur);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager handler) {
    }

    public boolean isActive() {
        return false;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }

    public abstract void setColor(int var1);

    public abstract int getColor();

    static class Image
    extends ColoredImageWidget {
        private final DynamicTexture texture;
        private final int textureWidth;
        private final int textureHeight;
        private int color;
        private final boolean blur;

        public Image(int x, int y, int width, int height, DynamicTexture texture, int textureWidth, int textureHeight, int color, boolean blur) {
            super(x, y, width, height);
            this.texture = texture;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
            this.blur = blur;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            RenderType renderType = !this.blur ? JMRenderTypes.getIconNoBlur((AbstractTexture)this.texture) : JMRenderTypes.getIcon((AbstractTexture)this.texture);
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
            DrawUtil.drawQuad(graphics.pose(), vertexBuilder, this.color, 1.0f, (double)this.getX(), (double)this.getY(), (double)this.textureWidth, (double)this.textureHeight, 0.0, false);
            buffers.endLastBatch();
        }

        @Override
        public void setColor(int color) {
            this.color = color;
        }

        @Override
        public int getColor() {
            return this.color;
        }
    }
}

