/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RadioButton
extends Button {
    private static final ResourceLocation RADIO = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"ui/img/radio_buttons.png");
    int imageWidth;
    int imageHeight;
    private boolean state;

    public RadioButton(int width, int height, Component message, boolean state, Button.OnPress onPress) {
        super(0, 0, width + 5 + Minecraft.getInstance().font.width((FormattedText)message), height, message, onPress, DEFAULT_NARRATION);
        this.imageWidth = width;
        this.imageHeight = height;
        this.state = state;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int size = 9;
        int length = 36;
        int offset = this.state ? 0 : size;
        int selectedOffset = this.isHovered() ? length / 2 : 0;
        graphics.blit(RADIO, this.getX(), this.getY(), this.imageWidth, this.imageHeight, (float)(offset + selectedOffset), 0.0f, size, size, length, size);
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.imageWidth + 5, this.getY(), i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void toggle() {
        this.state = !this.state;
    }

    public boolean state() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }
}

