/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.block;

import com.google.common.base.Objects;
import java.util.Optional;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.BiomeInvoker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BiomeMD
implements Comparable<BiomeMD> {
    public static final BiomeMD THE_VOID = new BiomeMD(BiomeMD.createTheVoidBiome(), "journeymap:the_void", false);
    public static final String EMPTY_ID = "journeymap:empty";
    private static final Logger LOGGER = Journeymap.getLogger();
    private final Biome biome;
    private final String biomeId;
    private int grassColor;
    private int fogColor;
    private int foliageColor;
    private int waterColor;

    private static Biome createTheVoidBiome() {
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().fogColor(0).waterColor(0).waterFogColor(0).skyColor(0).build();
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(specialEffects).mobSpawnSettings(MobSpawnSettings.EMPTY).generationSettings(BiomeGenerationSettings.EMPTY).temperatureAdjustment(Biome.TemperatureModifier.NONE).build();
    }

    public BiomeMD(@NotNull Biome biome, String id, boolean addToPalette) {
        this.biome = biome;
        this.biomeId = id;
        this.grassColor = biome.getSpecialEffects().getGrassColorOverride().orElseGet(() -> ((BiomeInvoker)biome).invokeGetGrassColorFromTexture());
        this.fogColor = biome.getFogColor();
        this.foliageColor = biome.getFoliageColor();
        this.waterColor = biome.getWaterColor();
        if (addToPalette) {
            ColorManager.INSTANCE.addNewBiomeColor(this);
        }
    }

    public static BiomeMD get(Biome biome) {
        ClientLevel level = Minecraft.getInstance().level;
        Optional key = level.registryAccess().registryOrThrow(Registries.BIOME).getResourceKey((Object)biome);
        if (key.isPresent()) {
            return BiomeMD.get((ResourceKey<Biome>)((ResourceKey)key.get()));
        }
        return new BiomeMD(biome, EMPTY_ID, false);
    }

    public static BiomeMD get(ResourceKey<Biome> key) {
        return DataCache.INSTANCE.getBiomeMD(key);
    }

    public String getBiomeId() {
        return this.biomeId;
    }

    public int getGrassColor(double posX, double posZ) {
        return this.biome.getSpecialEffects().getGrassColorModifier().modifyColor(posX, posZ, this.grassColor);
    }

    public int getGrassColor() {
        return this.grassColor;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getFoliageColor() {
        return this.foliageColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public void setGrassColor(int color) {
        this.grassColor = color;
    }

    public void setFogColor(int color) {
        this.fogColor = color;
    }

    public void setFoliageColor(int color) {
        this.foliageColor = color;
    }

    public void setWaterColor(int color) {
        this.waterColor = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BiomeMD)) {
            return false;
        }
        BiomeMD biomeMD = (BiomeMD)o;
        return this.biome.equals(biomeMD.biome);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.biome});
    }

    public String toString() {
        return String.format("BiomeMD [%s]", BiomeHelper.getBiomeResource(this.biome));
    }

    @Override
    public int compareTo(BiomeMD that) {
        return BiomeHelper.getBiomeResource(this.biome).compareTo(BiomeHelper.getBiomeResource(that.biome));
    }

    public static class CacheLoader
    extends com.google.common.cache.CacheLoader<ResourceKey<Biome>, BiomeMD> {
        public BiomeMD load(@NotNull ResourceKey<Biome> key) throws Exception {
            String id = key.location().toString();
            Minecraft mc = Minecraft.getInstance();
            Optional biome = mc.level.registryAccess().registryOrThrow(Registries.BIOME).getOptional(key);
            try {
                if (biome == null || biome.isEmpty()) {
                    LOGGER.warn("Null biome will be treated like the void: {}", key);
                    return THE_VOID;
                }
                return new BiomeMD((Biome)biome.get(), id, true);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Can't get BiomeMD for %s : %s", id, LogFormatter.toPartialString(e)));
                return THE_VOID;
            }
        }
    }
}

