/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class Stratum {
    private static AtomicInteger IDGEN = new AtomicInteger(0);
    private final int id = IDGEN.incrementAndGet();
    private ChunkMD chunkMd;
    private BlockMD blockMD;
    private int localX;
    private int y;
    private int localZ;
    private int lightLevel;
    private int lightOpacity;
    private boolean isFluid;
    private int dayColor;
    private int nightColor;
    private int caveColor;
    private float worldAmbientLight;
    private boolean worldHasNoSky;
    private boolean uninitialized = true;

    Stratum() {
    }

    Stratum set(ChunkMD chunkMd, BlockMD blockMD, int localX, int y, int localZ, Integer lightLevel) {
        if (chunkMd == null || blockMD == null) {
            throw new IllegalStateException(String.format("Can't have nulls: %s, %s", chunkMd, blockMD));
        }
        this.setChunkMd(chunkMd);
        this.setBlockMD(blockMD);
        this.setX(localX);
        this.setY(y);
        this.setZ(localZ);
        this.setFluid(blockMD.isFluid() || blockMD.isFluid());
        if (blockMD.isLava()) {
            this.setLightLevel(14);
        } else {
            this.setLightLevel(lightLevel != null ? lightLevel.intValue() : chunkMd.getSavedLightValue(localX, y + 1, localZ));
        }
        this.setLightOpacity(chunkMd.getLightOpacity(blockMD, localX, y, localZ));
        this.setDayColor(-1);
        this.setNightColor(-1);
        this.setCaveColor(-1);
        this.uninitialized = false;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stratum that = (Stratum)o;
        if (this.getY() != that.getY()) {
            return false;
        }
        return !(this.getBlockMD() != null ? !this.getBlockMD().equals(that.getBlockMD()) : that.getBlockMD() != null);
    }

    public int hashCode() {
        int result = this.getBlockMD() != null ? this.getBlockMD().hashCode() : 0;
        result = 31 * result + this.getY();
        return result;
    }

    public String toString() {
        String common = "Stratum{id=" + this.id + ", uninitialized=" + this.uninitialized + "%s}";
        if (!this.uninitialized) {
            return String.format(common, ", localX=" + this.getX() + ", y=" + this.getY() + ", localZ=" + this.getZ() + ", lightLevel=" + this.getLightLevel() + ", worldAmbientLight=" + this.getWorldAmbientLight() + ", lightOpacity=" + this.getLightOpacity() + ", isFluid=" + this.isFluid() + ", dayColor=" + String.valueOf(this.getDayColor() == -1 ? null : new Color(this.getDayColor())) + ", nightColor=" + String.valueOf(this.getNightColor() == -1 ? null : new Color(this.getNightColor())) + ", caveColor=" + String.valueOf(this.getCaveColor() == -1 ? null : new Color(this.getCaveColor())));
        }
        return String.format(common, "");
    }

    public ChunkMD getChunkMd() {
        return this.chunkMd;
    }

    public void setChunkMd(ChunkMD chunkMd) {
        this.chunkMd = chunkMd;
        if (chunkMd != null) {
            this.worldAmbientLight = chunkMd.getWorld().getSkyDarken(1.0f) * 15.0f;
            this.worldHasNoSky = chunkMd.hasNoSky();
        } else {
            this.worldAmbientLight = 15.0f;
            this.worldHasNoSky = false;
        }
    }

    public BlockMD getBlockMD() {
        if (this.blockMD.isFluid()) {
            boolean bl = false;
        }
        return this.blockMD;
    }

    public void setBlockMD(BlockMD blockMD) {
        this.blockMD = blockMD;
    }

    public float getWorldAmbientLight() {
        return this.worldAmbientLight;
    }

    public boolean getWorldHasNoSky() {
        return this.worldHasNoSky;
    }

    public int getX() {
        return this.localX;
    }

    public void setX(int x) {
        this.localX = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.localZ;
    }

    public void setZ(int z) {
        this.localZ = z;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    public int getLightOpacity() {
        return this.lightOpacity;
    }

    public void setLightOpacity(int lightOpacity) {
        this.lightOpacity = lightOpacity;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public void setFluid(boolean isFluid) {
        this.isFluid = isFluid;
    }

    public int getDayColor() {
        return this.dayColor;
    }

    public void setDayColor(int dayColor) {
        this.dayColor = dayColor;
    }

    public int getNightColor() {
        return this.nightColor;
    }

    public void setNightColor(int nightColor) {
        this.nightColor = nightColor;
    }

    public int getCaveColor() {
        return this.caveColor;
    }

    public void setCaveColor(int caveColor) {
        this.caveColor = caveColor;
    }

    public BlockPos getBlockPos() {
        return new BlockPos((Vec3i)this.chunkMd.getBlockPos(this.localX, this.y, this.localZ));
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public void clear() {
        this.uninitialized = true;
        this.worldAmbientLight = 15.0f;
        this.worldHasNoSky = false;
        this.setChunkMd(null);
        this.setBlockMD(null);
        this.setX(0);
        this.setY(-1);
        this.setZ(0);
        this.setFluid(false);
        this.setLightLevel(-1);
        this.setLightOpacity(-1);
        this.setDayColor(-1);
        this.setNightColor(-1);
        this.setCaveColor(-1);
    }
}

