/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sneakycurses.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.RenderBuffersContext;
import fuzs.puzzleslib.api.client.event.v1.entity.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderLevelEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import fuzs.sneakycurses.SneakyCurses;
import fuzs.sneakycurses.client.handler.ItemTooltipHandler;
import fuzs.sneakycurses.client.renderer.GlintRenderTypes;
import fuzs.sneakycurses.network.client.ServerboundRequestTridentItemMessage;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.projectile.ThrownTrident;

public class SneakyCursesClient
implements ClientModConstructor {
    public void onConstructMod() {
        SneakyCursesClient.registerHandlers();
    }

    private static void registerHandlers() {
        ItemTooltipCallback.EVENT.register(ItemTooltipHandler::onItemTooltip);
        ScreenEvents.afterInit(Screen.class).register(ItemTooltipHandler::onAfterInit);
        RenderLevelEvents.AFTER_TRANSLUCENT.register((levelRenderer, camera, gameRenderer, tickDelta, poseStack, projectionMatrix, frustum, level) -> {
            MultiBufferSource.BufferSource multiBufferSource = gameRenderer.getMinecraft().renderBuffers().bufferSource();
            GlintRenderTypes.GLINT_RENDER_TYPES.keySet().forEach(arg_0 -> ((MultiBufferSource.BufferSource)multiBufferSource).endBatch(arg_0));
        });
        ClientEntityLevelEvents.LOAD.register((entity, level) -> {
            if (entity instanceof ThrownTrident) {
                SneakyCurses.NETWORK.sendToServer((ServerboundMessage)new ServerboundRequestTridentItemMessage(entity.getId()));
            }
            return EventResult.PASS;
        });
    }

    public void onRegisterRenderBuffers(RenderBuffersContext context) {
        GlintRenderTypes.GLINT_RENDER_TYPES.keySet().forEach(xva$0 -> context.registerRenderBuffer(new RenderType[]{xva$0}));
    }
}

