/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen.custom.pathstyle;

import com.amber.roads.init.TravelersInit;
import com.amber.roads.util.TravelersDirection;
import com.amber.roads.world.PathNode;
import com.amber.roads.worldgen.custom.pathstyle.PathStyle;
import com.amber.roads.worldgen.custom.pathstyle.StyleModifierType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class PercentStyle
extends PathStyle {
    public static final MapCodec<PercentStyle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(PercentStyle.settingsCodec(instance), (App)ExtraCodecs.nonEmptyList((Codec)BlockState.CODEC.listOf()).fieldOf("texture_blocks").forGetter(style -> style.textureBlocks), (App)Codec.intRange((int)0, (int)100).fieldOf("main_block_chance").forGetter(style -> style.minBlockChance), (App)Codec.intRange((int)0, (int)100).fieldOf("texture_block_chance").forGetter(style -> style.textureBlockChance), (App)Codec.intRange((int)0, (int)100).fieldOf("skip_block_chance").forGetter(style -> style.skipBlockChance)).apply((Applicative)instance, PercentStyle::new));
    protected final List<BlockState> textureBlocks;
    protected final int minBlockChance;
    protected final int textureBlockChance;
    protected final int skipBlockChance;
    protected final int totalChance;

    public PercentStyle(PathStyle.PathSettings settings, List<BlockState> textureBlocks, int mainBlockChance, int textureBlockChance, int skipBlockChance) {
        super(settings);
        this.textureBlocks = textureBlocks;
        this.minBlockChance = mainBlockChance;
        this.textureBlockChance = textureBlockChance;
        this.skipBlockChance = skipBlockChance;
        this.totalChance = mainBlockChance + textureBlockChance + skipBlockChance;
    }

    @Override
    public void setPathBlock(ServerLevel level, BlockPos originPos) {
        RandomSource randomSource = level.getRandom();
        int blockValue = randomSource.nextInt(this.totalChance);
        BlockState setState = null;
        if (blockValue <= this.minBlockChance) {
            setState = this.settings.mainPathBlock().getState(randomSource, originPos);
        } else if (blockValue - this.minBlockChance <= this.textureBlockChance) {
            setState = this.textureBlocks.get(randomSource.nextInt(this.textureBlocks.size()));
        }
        if (setState != null) {
            level.setBlock(originPos, setState.rotate((LevelAccessor)level, originPos, Rotation.getRandom((RandomSource)randomSource)), 2);
        }
    }

    @Override
    public void placeExtraBlocks(ServerLevel level, PathNode pos1, TravelersDirection direction, List<BlockPos> extraBlockPositions) {
    }

    @Override
    public MapCodec<? extends PathStyle> codec() {
        return CODEC;
    }

    @Override
    public StyleModifierType<?> type() {
        return (StyleModifierType)TravelersInit.PERCENT_STYLE.get();
    }
}

