/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen.custom.pathstyle;

import com.amber.roads.init.TravelersInit;
import com.amber.roads.init.TravelersRegistries;
import com.amber.roads.util.PathSize;
import com.amber.roads.util.TravelersDirection;
import com.amber.roads.util.TravelersTags;
import com.amber.roads.util.TravelersUtil;
import com.amber.roads.world.PathNode;
import com.amber.roads.world.PathPos;
import com.amber.roads.worldgen.custom.pathstyle.StyleModifierType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public abstract class PathStyle {
    public static final Codec<PathStyle> DIRECT_CODEC = TravelersRegistries.PATH_STYLE_TYPE.byNameCodec().dispatch(PathStyle::type, StyleModifierType::codec);
    public static final Codec<Holder<PathStyle>> REFERENCE_CODEC = RegistryFileCodec.create(TravelersRegistries.Keys.PATH_STYLES, DIRECT_CODEC);
    protected final PathSettings settings;
    protected final PathSize pathSize;

    public static <S extends PathStyle> RecordCodecBuilder<S, PathSettings> settingsCodec(RecordCodecBuilder.Instance<S> instance) {
        return PathSettings.CODEC.forGetter(style -> style.settings);
    }

    protected PathStyle(PathSettings settings) {
        this.settings = settings;
        this.pathSize = PathSize.valueOf(settings.pathSize);
    }

    public boolean checkBiome(Holder<Biome> checkBiome) {
        Predicate<Holder> predicate = arg_0 -> this.settings.biomes.contains(arg_0);
        return predicate.test(checkBiome);
    }

    public abstract void setPathBlock(ServerLevel var1, BlockPos var2);

    public boolean placeSection(ServerLevel level, PathNode pos1, PathNode pos2) {
        if (!level.hasChunk(pos1.getChunkX(), pos1.getChunkZ()) || !level.hasChunk(pos2.getChunkX(), pos2.getChunkZ())) {
            return false;
        }
        float distance = (float)TravelersUtil.distanceTo2D(pos1, pos2);
        TravelersDirection direction = TravelersDirection.directionFromPos(pos1, pos2);
        int width = this.pathSize.getWidth();
        int extraWidth = this.pathSize.getExtraWidth();
        ArrayList<BlockPos> pathBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> extraBlocks = new ArrayList<BlockPos>();
        PathPos currPos = pos1.asPathPos();
        if (!TravelersUtil.isEven(width)) {
            currPos.offset(0.5f * direction.getStepX(), 0.5f * direction.getStepZ());
        }
        ArrayList<PathPos> linePos = new ArrayList<PathPos>();
        int i = 0;
        while ((float)i < distance) {
            linePos.add(currPos);
            currPos = currPos.relative(direction);
            ++i;
        }
        int xWidth = Mth.floor((float)Mth.abs((float)((float)width / 2.0f * direction.getZ())));
        int zWidth = Mth.floor((float)Mth.abs((float)((float)width / 2.0f * direction.getX())));
        int xExtraWidth = Mth.floor((float)Mth.abs((float)((float)extraWidth / 2.0f * direction.getZ())));
        int zExtraWidth = Mth.floor((float)Mth.abs((float)((float)extraWidth / 2.0f * direction.getX())));
        for (PathPos pos : linePos) {
            int z;
            int x;
            if (width == 1) {
                pathBlocks.add(pos.asBlockPos());
            } else {
                for (x = -xWidth; x < zWidth; ++x) {
                    for (z = -zWidth; z < zWidth; ++z) {
                        pathBlocks.add(pos.offset(x, z).asBlockPos());
                    }
                }
            }
            for (x = -xExtraWidth; x < xExtraWidth; ++x) {
                for (z = -zExtraWidth; z < zExtraWidth; ++z) {
                    BlockPos extraPos = pos.offset(x, z).asBlockPos();
                    if (pathBlocks.contains(extraPos)) continue;
                    extraBlocks.add(extraPos);
                }
            }
        }
        BlockPos sectionCenter = direction.nextSectionCenter(pos1, Mth.floor((float)distance));
        int generationY = level.getChunkSource().getGenerator().getFirstOccupiedHeight(sectionCenter.getX(), sectionCenter.getZ(), Heightmap.Types.WORLD_SURFACE, (LevelHeightAccessor)level, level.getChunkSource().randomState());
        for (BlockPos position : pathBlocks.stream().distinct().toList()) {
            Optional<BlockPos> newPlacePos = PathStyle.findY(level, position.above(generationY));
            newPlacePos.ifPresent(blockPos -> {
                boolean cairnAbove = level.getBlockState(blockPos.above()).is(TravelersInit.CAIRN.get());
                this.setPathBlock(level, (BlockPos)blockPos);
                if (level.getBlockState(blockPos.above()).is(Blocks.SNOW) && (double)level.random.nextFloat() > 0.8) {
                    level.setBlock(blockPos.above(), Blocks.AIR.defaultBlockState(), 2);
                }
                if (cairnAbove) {
                    level.setBlock(blockPos.above(), TravelersInit.CAIRN.get().defaultBlockState(), 2);
                }
            });
        }
        this.placeExtraBlocks(level, pos1, direction, extraBlocks.stream().distinct().toList());
        return true;
    }

    public abstract void placeExtraBlocks(ServerLevel var1, PathNode var2, TravelersDirection var3, List<BlockPos> var4);

    public static Optional<BlockPos> findY(ServerLevel level, BlockPos origin) {
        while (!level.getBlockState(origin.above()).is(TravelersTags.Blocks.PATH_ABOVE) || !level.getBlockState(origin).is(TravelersTags.Blocks.PATH_BELOW)) {
            if (level.getBlockState(origin.above()).getFluidState().isSource() || level.getBlockState(origin).getFluidState().isSource()) {
                return Optional.empty();
            }
            if (level.getBlockState(origin).is(TravelersTags.Blocks.PATH_ABOVE)) {
                origin = origin.below();
                continue;
            }
            if (!level.getBlockState(origin.above()).is(TravelersTags.Blocks.PATH_BELOW)) break;
            origin = origin.above();
        }
        return Optional.of(origin);
    }

    public int getDistance() {
        return this.pathSize.getDistance();
    }

    public int getWidth() {
        return this.pathSize.getWidth();
    }

    public int getNodeDistance() {
        return this.pathSize.getNodesPerImportantNode();
    }

    abstract MapCodec<? extends PathStyle> codec();

    public abstract StyleModifierType<?> type();

    public record PathSettings(HolderSet<Biome> biomes, BlockStateProvider mainPathBlock, String pathSize) {
        public static final MapCodec<PathSettings> CODEC = RecordCodecBuilder.mapCodec(p_351995_ -> p_351995_.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(PathSettings::biomes), (App)BlockStateProvider.CODEC.fieldOf("main_path_block").forGetter(PathSettings::mainPathBlock), (App)Codec.STRING.fieldOf("pathSize").forGetter(PathSettings::pathSize)).apply((Applicative)p_351995_, PathSettings::new));
    }
}

