/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen.custom;

import com.amber.roads.TravelersConfig;
import com.amber.roads.TravelersCrossroads;
import com.amber.roads.init.TravelersInit;
import com.amber.roads.util.TravelersUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class DistanceFilter
extends PlacementFilter {
    public static final MapCodec<DistanceFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("distance").forGetter(distanceFilter -> distanceFilter.distance)).apply((Applicative)instance, instance.stable(DistanceFilter::new)));
    public final int distance;

    public DistanceFilter(int distance) {
        this.distance = distance;
    }

    public static DistanceFilter minimumEvery(int distance) {
        return new DistanceFilter(distance);
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        Optional<ChunkPos> closestPath = TravelersCrossroads.WATCHER.getClosest(pos, this.distance);
        if (closestPath.isPresent() || TravelersUtil.chunkDistanceTo(ChunkPos.ZERO, new ChunkPos(pos)) < TravelersConfig.distanceFromWorldCenter) {
            return false;
        }
        closestPath.ifPresent(pathPos -> TravelersCrossroads.LOGGER.debug("Acceptable cairn pos distance {}", (Object)TravelersUtil.chunkDistanceTo(new ChunkPos(pos), pathPos)));
        TravelersCrossroads.WATCHER.addDistanceFilterNode(new ChunkPos(pos));
        return true;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)TravelersInit.DISTANCE_FILTER.get();
    }
}

