/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen;

import com.amber.roads.TravelersCrossroads;
import com.amber.roads.init.TravelersRegistries;
import com.amber.roads.util.CrossroadsData;
import com.amber.roads.util.TravelersDirection;
import com.amber.roads.util.TravelersTags;
import com.amber.roads.util.TravelersUtil;
import com.amber.roads.world.PathNode;
import com.amber.roads.world.TravelersPath;
import com.amber.roads.worldgen.TravelersFeatures;
import com.amber.roads.worldgen.custom.OffsetModifier;
import com.amber.roads.worldgen.custom.pathstyle.PathStyle;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="travelers_crossroads", bus=EventBusSubscriber.Bus.GAME)
public class TravelersWatcher {
    public static MinecraftServer server;
    public static Registry<PathStyle> pathStyleReg;
    public static Registry<OffsetModifier> pathOffsets;
    public static List<PathStyle> pathStyles;
    public static RandomSource randomSource;
    public static int tickCount;
    public static CrossroadsData crossroadsData;
    public static ArrayList<BlockPos> newCrossroadPositions;
    public static ArrayList<ChunkPos> beforeServerLoadNodes;

    public void addCrossroadToCreate(BlockPos center) {
        newCrossroadPositions.add(center);
    }

    public void placeCrossroad(BlockPos center) {
        Holder biome = server.overworld().getBiome(center);
        PathNode centerPos = new PathNode(center);
        List<PathStyle> possiblePathStyles = pathStyles.stream().filter(pathBiomeStyleHolder -> pathBiomeStyleHolder.checkBiome((Holder<Biome>)biome)).toList();
        PathStyle pathStyle = possiblePathStyles.get(randomSource.nextInt(possiblePathStyles.size()));
        List<TravelersPath> connectionPaths = this.placeConnectionPaths(pathStyle, centerPos);
        ArrayList<PathNode> connectionNodes = new ArrayList<PathNode>();
        connectionNodes.add(centerPos);
        for (TravelersPath travelersPath : connectionPaths) {
            this.addPath(travelersPath);
            connectionNodes.add(travelersPath.getEnd());
            crossroadsData.addPathNode(travelersPath.getEnd());
        }
        List<Pair<ChunkPos, Holder<Structure>>> structures = this.getNearbyStructures(center, connectionNodes);
        for (Pair<ChunkPos, Holder<Structure>> pair : structures) {
            OffsetModifier offset = null;
            for (OffsetModifier offsetCheck : pathOffsets.holders().map(Holder::value).toList()) {
                if (!offsetCheck.checkStructure((Holder<Structure>)((Holder)pair.getSecond()))) continue;
                offset = offsetCheck;
            }
            if (offset == null) {
                offset = (OffsetModifier)pathOffsets.getOrThrow(TravelersFeatures.DEFAULT_OFFSET_KEY);
            }
            PathNode structPathPos = new PathNode((ChunkPos)pair.getFirst());
            TravelersDirection direction = TravelersDirection.directionFromPos(structPathPos, centerPos);
            structPathPos = direction.nextPos(structPathPos, offset.getOffset());
            PathNode closest = centerPos;
            double distance = 0.0;
            for (PathNode connection : connectionNodes) {
                distance = TravelersUtil.distanceTo2D(structPathPos, connection);
                closest = distance < TravelersUtil.distanceTo2D(closest, structPathPos) ? connection : closest;
            }
            if (distance <= (double)pathStyle.getDistance()) break;
            this.addPath(new TravelersPath(randomSource, closest, structPathPos, pathStyle));
            TravelersCrossroads.LOGGER.debug("Structure Path - Start:  {} | End: {} | Structure {}", new Object[]{closest, structPathPos, ((Holder)pair.getSecond()).getRegisteredName()});
        }
        if (structures.isEmpty()) {
            Optional<ChunkPos> optional = this.getClosestAvoidCurrent(center, 30, connectionNodes);
            optional.ifPresent(pos -> this.addPath(new TravelersPath(randomSource, centerPos, new PathNode((ChunkPos)pos), pathStyle)));
        }
    }

    public List<TravelersPath> placeConnectionPaths(PathStyle pathStyle, PathNode centerPos) {
        ArrayList<? extends TravelersDirection> connectionDirections = new ArrayList<TravelersDirection>();
        ArrayList<TravelersPath> paths = new ArrayList<TravelersPath>();
        int distance = pathStyle.getDistance();
        PathNode nextPos = centerPos;
        for (int i = 0; i < randomSource.nextInt(2) + 1; ++i) {
            TravelersDirection startDirection;
            while (connectionDirections.contains((Object)(startDirection = TravelersDirection.getRandom(randomSource)))) {
            }
            nextPos = startDirection.nextPos(nextPos, distance);
            for (int j = 0; j < randomSource.nextInt(7 - pathStyle.getWidth()) + 7; ++j) {
                TravelersDirection nextDirection = startDirection.getRandomForDirection(randomSource);
                nextPos = nextDirection.nextPos(nextPos, distance);
            }
            paths.add(new TravelersPath(randomSource, centerPos, nextPos, pathStyle));
            connectionDirections.addAll(startDirection.getNeighbors());
        }
        return paths;
    }

    public void addPath(TravelersPath path) {
        crossroadsData.addPath(path);
        crossroadsData.addPathNode(path.getEnd());
    }

    public List<Pair<ChunkPos, Holder<Structure>>> getNearbyStructures(BlockPos center, List<PathNode> pathNodeList) {
        ChunkPos structChunkPos;
        int distance;
        ArrayList<Pair> structs = new ArrayList<Pair>();
        ChunkPos centerChunk = new ChunkPos(center);
        Pair<BlockPos, Holder<Structure>> struct = this.findNearestMapStructure(TravelersTags.Structures.PATH_STRUCTURES, center);
        if (struct != null && (distance = TravelersUtil.chunkDistanceTo(centerChunk, structChunkPos = new ChunkPos((BlockPos)struct.getFirst()))) <= 20 && distance > 4) {
            structs.add(Pair.of((Object)structChunkPos, (Object)((Holder)struct.getSecond())));
        }
        for (PathNode pos : pathNodeList) {
            ChunkPos structChunkPos2;
            int distance2;
            struct = this.findNearestMapStructure(TravelersTags.Structures.PATH_STRUCTURES, pos.asBlockPos());
            if (struct == null || (distance2 = TravelersUtil.chunkDistanceTo(centerChunk, structChunkPos2 = new ChunkPos((BlockPos)struct.getFirst()))) > 20 || distance2 <= 1) continue;
            structs.add(Pair.of((Object)structChunkPos2, (Object)((Holder)struct.getSecond())));
            TravelersCrossroads.LOGGER.debug("Structure found {} {}", struct.getFirst(), struct.getSecond());
        }
        return structs.stream().distinct().toList();
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(TagKey<Structure> structureTag, BlockPos pos) {
        if (!server.getWorldData().worldGenOptions().generateStructures()) {
            return null;
        }
        ServerLevel level = server.overworld();
        Optional optional = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(structureTag);
        return optional.map(holders -> level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)holders, pos, 30, false)).orElse(null);
    }

    public Optional<ChunkPos> getClosest(BlockPos checkPos, int distance) {
        Optional<ChunkPos> foundPos = Optional.empty();
        ChunkPos chunkPos = new ChunkPos(checkPos);
        if (crossroadsData == null) {
            for (ChunkPos pos : beforeServerLoadNodes) {
                int newDist = TravelersUtil.chunkDistanceTo(chunkPos, pos);
                if (newDist >= distance) continue;
                distance = newDist;
                foundPos = Optional.of(pos);
            }
            return foundPos;
        }
        for (PathNode pathPos : crossroadsData.getPathNodes()) {
            int newDist = TravelersUtil.chunkDistanceTo(chunkPos, pathPos.asChunkPos());
            if (newDist >= distance) continue;
            distance = newDist;
            foundPos = Optional.of(pathPos.asChunkPos());
        }
        return foundPos;
    }

    public Optional<ChunkPos> getClosestAvoidCurrent(BlockPos checkPos, int distance, List<PathNode> currentNodes) {
        int newDist;
        Optional<ChunkPos> foundPos = Optional.empty();
        ChunkPos chunkPos = new ChunkPos(checkPos);
        int farthestCurrent = 0;
        for (PathNode pathPos : currentNodes) {
            newDist = TravelersUtil.chunkDistanceTo(chunkPos, pathPos.asChunkPos());
            if (newDist <= farthestCurrent) continue;
            farthestCurrent = newDist;
        }
        if (crossroadsData == null) {
            for (ChunkPos pos : beforeServerLoadNodes) {
                newDist = TravelersUtil.chunkDistanceTo(chunkPos, pos);
                if (newDist >= distance) continue;
                distance = newDist;
                foundPos = Optional.of(pos);
            }
            return foundPos;
        }
        for (PathNode pathPos : crossroadsData.getPathNodes()) {
            newDist = TravelersUtil.chunkDistanceTo(chunkPos, pathPos.asChunkPos());
            if (newDist <= farthestCurrent || newDist >= distance) continue;
            distance = newDist;
            foundPos = Optional.of(pathPos.asChunkPos());
        }
        return foundPos;
    }

    public void addDistanceFilterNode(ChunkPos pos) {
        if (crossroadsData == null) {
            beforeServerLoadNodes.add(pos);
        } else {
            crossroadsData.addPathNode(new PathNode(pos));
        }
    }

    public void removeDistanceFilterNode(ChunkPos pos) {
        if (crossroadsData == null) {
            beforeServerLoadNodes.remove(pos);
        } else {
            crossroadsData.removePathNode(new PathNode(pos));
        }
    }

    @SubscribeEvent
    public static void tick(ServerTickEvent.Post event) {
        if (!event.hasTime()) {
            return;
        }
        TravelersCrossroads.WATCHER.buildPaths();
    }

    public void buildPaths() {
        if (++tickCount % 3 != 0) {
            return;
        }
        if (!newCrossroadPositions.isEmpty()) {
            this.placeCrossroad(newCrossroadPositions.removeFirst());
        }
        ArrayList<TravelersPath> paths = crossroadsData.getUnfinishedPaths();
        for (TravelersPath path : paths) {
            if (path.completed()) continue;
            try {
                path.placeNextSection(server.overworld());
            }
            catch (Exception e) {
                System.out.println("path placement failed: ");
                e.printStackTrace();
            }
        }
        crossroadsData.checkPaths();
    }

    public void setServer(MinecraftServer newServer) {
        server = newServer;
        pathOffsets = server.registryAccess().registryOrThrow(TravelersRegistries.Keys.STRUCTURE_OFFSETS);
        pathStyleReg = server.registryAccess().registryOrThrow(TravelersRegistries.Keys.PATH_STYLES);
        pathStyles = pathStyleReg.holders().map(Holder::value).toList();
    }

    public void setPathData() {
        crossroadsData = CrossroadsData.instance(server.overworld().getDataStorage());
        TravelersCrossroads.LOGGER.debug("Server Load adding beforeServerLoadNodes {}", (Object)beforeServerLoadNodes.size());
        beforeServerLoadNodes.forEach(pos -> crossroadsData.addPathNode(new PathNode((ChunkPos)pos)));
        randomSource = RandomSource.create((long)server.overworld().getSeed());
    }

    static {
        tickCount = 0;
        crossroadsData = null;
        newCrossroadPositions = new ArrayList();
        beforeServerLoadNodes = new ArrayList();
    }
}

