/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen;

import com.amber.roads.TravelersCrossroads;
import com.amber.roads.block.CairnBlock;
import com.amber.roads.init.TravelersInit;
import com.amber.roads.util.TravelersTags;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TravelersStart
extends Feature<NoneFeatureConfiguration> {
    public TravelersStart(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext context) {
        return this.place(context.level(), context.random(), context.origin());
    }

    public boolean place(WorldGenLevel level, RandomSource random, BlockPos origin) {
        Optional<BlockPos> cairnPos;
        ChunkPos originChunk = new ChunkPos(origin);
        origin = originChunk.getMiddleBlockPosition(origin.getY());
        for (int x = originChunk.x - 1; x <= originChunk.x + 1; ++x) {
            for (int z = originChunk.z - 1; z <= originChunk.z + 1; ++z) {
                if (!level.getBiome(new ChunkPos(x, z).getMiddleBlockPosition(origin.getY())).is(TravelersTags.Biomes.PATH_START_AVOID_BIOME)) continue;
                TravelersCrossroads.LOGGER.debug("Bad Biome at: {}", (Object)origin);
                return false;
            }
        }
        TravelersCrossroads.LOGGER.debug("Spawning Feature at: {}", (Object)origin);
        int tries = 0;
        do {
            cairnPos = Optional.of(origin.offset(random.nextInt(4) - 2, 0, random.nextInt(4) - 2));
        } while ((cairnPos = TravelersStart.findY(level, cairnPos.get())).isEmpty() && ++tries < 16);
        cairnPos.ifPresent(blockPos -> {
            level.setBlock(blockPos.above(), (BlockState)TravelersInit.CAIRN.get().defaultBlockState().setValue((Property)CairnBlock.FACING, (Comparable)Direction.from2DDataValue((int)random.nextInt(4))), 3);
            TravelersCrossroads.WATCHER.addCrossroadToCreate((BlockPos)blockPos);
        });
        if (cairnPos.isEmpty()) {
            TravelersCrossroads.LOGGER.debug("Removed Pos {}", (Object)originChunk);
            TravelersCrossroads.WATCHER.removeDistanceFilterNode(originChunk);
            return false;
        }
        return true;
    }

    public static Optional<BlockPos> findY(WorldGenLevel level, BlockPos origin) {
        while (!level.getBlockState(origin.above()).is(TravelersTags.Blocks.PATH_ABOVE) || !level.getBlockState(origin).is(TravelersTags.Blocks.PATH_BELOW)) {
            if (level.getBlockState(origin.above()).getFluidState().isSource() || level.getBlockState(origin).getFluidState().isSource()) {
                return Optional.empty();
            }
            if (level.getBlockState(origin).is(TravelersTags.Blocks.PATH_ABOVE)) {
                origin = origin.below();
                continue;
            }
            if (!level.getBlockState(origin.above()).is(TravelersTags.Blocks.PATH_BELOW)) break;
            origin = origin.above();
        }
        return Optional.of(origin);
    }
}

