/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.worldgen;

import com.amber.roads.TravelersCrossroads;
import com.amber.roads.init.TravelersInit;
import com.amber.roads.init.TravelersRegistries;
import com.amber.roads.util.PathSize;
import com.amber.roads.util.TravelersTags;
import com.amber.roads.worldgen.custom.DistanceFilter;
import com.amber.roads.worldgen.custom.OffsetModifier;
import com.amber.roads.worldgen.custom.PathModifiers;
import com.amber.roads.worldgen.custom.pathstyle.PathStyle;
import com.amber.roads.worldgen.custom.pathstyle.PercentStyle;
import com.amber.roads.worldgen.custom.pathstyle.SparseStyle;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class TravelersFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_PATH_START = TravelersFeatures.registerConfiguredKey("configured_path_start");
    public static final ResourceKey<PlacedFeature> PLACED_PATH_START = TravelersFeatures.registerPlacedKey("placed_path_start");
    public static final ResourceKey<BiomeModifier> PATH_START_BIOMES = TravelersFeatures.registerBiomeKey("path_start_biomes");
    public static final ResourceKey<OffsetModifier> ZERO_OFFSET_KEY = TravelersFeatures.registerPathOffsetKey("zero_offset");
    public static final ResourceKey<OffsetModifier> DEFAULT_OFFSET_KEY = TravelersFeatures.registerPathOffsetKey("default_offset");
    public static final ResourceKey<OffsetModifier> VILLAGE_OFFSET_KEY = TravelersFeatures.registerPathOffsetKey("village_offset");
    public static final ResourceKey<OffsetModifier> MANSION_OFFSET_KEY = TravelersFeatures.registerPathOffsetKey("mansion_offset");
    public static final ResourceKey<PathStyle> DEFAULT_STYLE_KEY = TravelersFeatures.registerPathStyleKey("default_style");
    public static final ResourceKey<PathStyle> STONE_BRICKS_STYLE_KEY = TravelersFeatures.registerPathStyleKey("stone_bricks_style");
    public static final ResourceKey<PathStyle> ERODED_STONE_BRICKS_STYLE_KEY = TravelersFeatures.registerPathStyleKey("eroded_stone_bricks_style");
    public static final ResourceKey<PathStyle> RUSTIC_STYLE_KEY = TravelersFeatures.registerPathStyleKey("rustic_style");
    public static final ResourceKey<PathStyle> DESERT_STYLE_KEY = TravelersFeatures.registerPathStyleKey("desert_style");
    public static final ResourceKey<PathStyle> SPARSE_GRAVEL_STYLE_KEY = TravelersFeatures.registerPathStyleKey("sparse_gravel_style");
    public static final ResourceKey<PathStyle> BADLANDS_STYLE_KEY = TravelersFeatures.registerPathStyleKey("badlands_style");
    public static final ResourceKey<PathStyle> SAVANNA_STYLE_KEY = TravelersFeatures.registerPathStyleKey("savanna_style");
    public static final ResourceKey<PathStyle> SNOWY_STYLE_KEY = TravelersFeatures.registerPathStyleKey("snowy_style");
    public static final ResourceKey<PathStyle> SPARSE_SNOWY_STYLE_KEY = TravelersFeatures.registerPathStyleKey("sparse_snowy_style");
    public static final ResourceKey<PathStyle> JUNGLE_STYLE_KEY = TravelersFeatures.registerPathStyleKey("jungle_style");

    public static void configuredBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> configuredContext) {
        TravelersFeatures.configuredRegister(configuredContext, CONFIGURED_PATH_START, TravelersInit.TRAVELERS_BEGINNING.get(), FeatureConfiguration.NONE);
    }

    public static void placedBootstrap(BootstrapContext<PlacedFeature> placedContext) {
        HolderGetter configuredFeatures = placedContext.lookup(Registries.CONFIGURED_FEATURE);
        TravelersFeatures.placedRegister(placedContext, PLACED_PATH_START, configuredFeatures.getOrThrow(CONFIGURED_PATH_START), List.of(RarityFilter.onAverageOnceEvery((int)20), DistanceFilter.minimumEvery(16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
    }

    public static void biomeBootstrap(BootstrapContext<BiomeModifier> biomeContext) {
        HolderGetter placedFeatures = biomeContext.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = biomeContext.lookup(Registries.BIOME);
        biomeContext.register(PATH_START_BIOMES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(PLACED_PATH_START)}), GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
    }

    public static void pathOffsetBootstrap(BootstrapContext<OffsetModifier> pathOffsetContext) {
        HolderGetter structures = pathOffsetContext.lookup(Registries.STRUCTURE);
        pathOffsetContext.register(ZERO_OFFSET_KEY, (Object)new PathModifiers.DistanceModifier((HolderSet<Structure>)structures.getOrThrow(TravelersTags.Structures.ZERO_OFFSET_STRUCTURES), 0));
        pathOffsetContext.register(DEFAULT_OFFSET_KEY, (Object)new PathModifiers.DistanceModifier((HolderSet<Structure>)structures.getOrThrow(TravelersTags.Structures.DEFAULT_OFFSET_STRUCTURES), 10));
        pathOffsetContext.register(VILLAGE_OFFSET_KEY, (Object)new PathModifiers.DistanceModifier((HolderSet<Structure>)structures.getOrThrow(TravelersTags.Structures.VILLAGE_OFFSET_STRUCTURES), 20));
        pathOffsetContext.register(MANSION_OFFSET_KEY, (Object)new PathModifiers.DistanceModifier((HolderSet<Structure>)structures.getOrThrow(TravelersTags.Structures.MANSION_OFFSET_STRUCTURES), 20));
    }

    public static void pathBiomeStylesBootstrap(BootstrapContext<PathStyle> pathStylesContext) {
        HolderGetter biomes = pathStylesContext.lookup(Registries.BIOME);
        pathStylesContext.register(DEFAULT_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.DIRT_PATH), PathSize.SMALL.getSerializedName()), List.of(Blocks.GRAVEL.defaultBlockState(), Blocks.COARSE_DIRT.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(STONE_BRICKS_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(TravelersTags.Biomes.HAS_STONE_BRICKS_PATH), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE_BRICKS), PathSize.MEDIUM.getSerializedName()), List.of(Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICK_SLAB.defaultBlockState(), Blocks.COBBLESTONE.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(ERODED_STONE_BRICKS_STYLE_KEY, (Object)new SparseStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_MOUNTAIN), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE_BRICKS), PathSize.MEDIUM.getSerializedName()), List.of(Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), Blocks.COBBLESTONE.defaultBlockState())));
        pathStylesContext.register(RUSTIC_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.IS_FOREST), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.DIRT_PATH), PathSize.MINI.getSerializedName()), List.of(Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_STAIRS.defaultBlockState(), Blocks.COARSE_DIRT.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(DESERT_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(Tags.Biomes.IS_DESERT), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CUT_SANDSTONE), PathSize.SMALL.getSerializedName()), List.of(Blocks.GRAVEL.defaultBlockState(), Blocks.SANDSTONE_SLAB.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(SPARSE_GRAVEL_STYLE_KEY, (Object)new SparseStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(Tags.Biomes.IS_TEMPERATE_OVERWORLD), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.GRAVEL), PathSize.MINI.getSerializedName()), List.of(Blocks.COARSE_DIRT.defaultBlockState())));
        pathStylesContext.register(BADLANDS_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.IS_BADLANDS), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_SANDSTONE), PathSize.SMALL.getSerializedName()), List.of(Blocks.GRAVEL.defaultBlockState(), Blocks.RED_SANDSTONE_SLAB.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(SAVANNA_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.IS_SAVANNA), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ACACIA_PLANKS), PathSize.MEDIUM.getSerializedName()), List.of(Blocks.RED_SANDSTONE.defaultBlockState(), Blocks.ORANGE_TERRACOTTA.defaultBlockState(), Blocks.STRIPPED_ACACIA_WOOD.defaultBlockState()), 60, 30, 10));
        pathStylesContext.register(SNOWY_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.COBBLESTONE), PathSize.SMALL.getSerializedName()), List.of(Blocks.STONE.defaultBlockState(), Blocks.GRAVEL.defaultBlockState(), Blocks.BONE_BLOCK.defaultBlockState()), 65, 25, 10));
        pathStylesContext.register(SPARSE_SNOWY_STYLE_KEY, (Object)new SparseStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(Tags.Biomes.IS_SNOWY), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.COBBLESTONE), PathSize.MINI.getSerializedName()), List.of(Blocks.STONE.defaultBlockState(), Blocks.BONE_BLOCK.defaultBlockState())));
        pathStylesContext.register(JUNGLE_STYLE_KEY, (Object)new PercentStyle(new PathStyle.PathSettings((HolderSet<Biome>)biomes.getOrThrow(BiomeTags.IS_JUNGLE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.JUNGLE_PLANKS), PathSize.SMALL.getSerializedName()), List.of(Blocks.JUNGLE_SLAB.defaultBlockState(), Blocks.MOSS_BLOCK.defaultBlockState(), Blocks.OAK_LOG.defaultBlockState()), 60, 30, 10));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfiguredKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)TravelersCrossroads.travelersLocation(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void configuredRegister(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)TravelersCrossroads.travelersLocation(name));
    }

    private static void placedRegister(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static ResourceKey<BiomeModifier> registerBiomeKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)TravelersCrossroads.travelersLocation(name));
    }

    private static ResourceKey<OffsetModifier> registerPathOffsetKey(String name) {
        return ResourceKey.create(TravelersRegistries.Keys.STRUCTURE_OFFSETS, (ResourceLocation)TravelersCrossroads.travelersLocation(name));
    }

    private static ResourceKey<PathStyle> registerPathStyleKey(String name) {
        return ResourceKey.create(TravelersRegistries.Keys.PATH_STYLES, (ResourceLocation)TravelersCrossroads.travelersLocation(name));
    }
}

