/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.world;

import com.amber.roads.util.TravelersDirection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;

public class PathPos {
    public static final PathPos ZERO = new PathPos(0.0f, 0.0f);
    public final float x;
    public final float z;

    public PathPos(float x, float z) {
        this.x = x;
        this.z = z;
    }

    public PathPos(BlockPos pos) {
        this(pos.getX(), pos.getZ());
    }

    public PathPos(ChunkPos pos) {
        this(pos.getMiddleBlockX(), pos.getMiddleBlockZ());
    }

    public PathPos offset(float dx, float dz) {
        return dx == 0.0f && dz == 0.0f ? this : new PathPos(this.getX() + dx, this.getZ() + dz);
    }

    public PathPos offset(int dx, int dz) {
        return dx == 0 && dz == 0 ? this : new PathPos(this.getX() + (float)dx, this.getZ() + (float)dz);
    }

    public PathPos relative(TravelersDirection direction) {
        return new PathPos(this.getX() + direction.getStepX(), this.getZ() + direction.getStepZ());
    }

    public float getZ() {
        return this.z;
    }

    public float getX() {
        return this.x;
    }

    public float getChunkZ() {
        return SectionPos.blockToSectionCoord((double)this.z);
    }

    public float getChunkX() {
        return SectionPos.blockToSectionCoord((double)this.x);
    }

    public BlockPos asBlockPos() {
        return new BlockPos(Mth.floor((float)this.x), 0, Mth.floor((float)this.z));
    }

    public BlockPos asBlockPos(int y) {
        return new BlockPos(Mth.floor((float)this.x), y, Mth.floor((float)this.z));
    }

    public ChunkPos asChunkPos() {
        return new ChunkPos(this.asBlockPos());
    }

    public String toString() {
        return "X: " + this.x + "| Z: " + this.z;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPos pathPos = (PathPos)o;
        return this.getX() == pathPos.getX() && this.getZ() == pathPos.getZ();
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getX()), Float.valueOf(this.getZ()));
    }
}

