/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.world;

import com.amber.roads.world.PathPos;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;

public class PathNode {
    public static final PathNode ZERO = new PathNode(0, 0, false);
    public final int x;
    public final int z;
    public final boolean start;

    public PathNode(int x, int z, boolean start) {
        this.x = x;
        this.z = z;
        this.start = start;
    }

    public PathNode(BlockPos pos) {
        this(pos.getX(), pos.getZ(), false);
    }

    public PathNode(ChunkPos pos) {
        this(pos.getMiddleBlockX(), pos.getMiddleBlockZ(), false);
    }

    public PathNode(CompoundTag tag) {
        this.x = tag.getInt("x");
        this.z = tag.getInt("z");
        this.start = tag.getBoolean("start");
    }

    public CompoundTag save(CompoundTag tag, int index) {
        CompoundTag data = new CompoundTag();
        data.putInt("x", this.x);
        data.putInt("z", this.z);
        data.putBoolean("start", this.start);
        tag.put(String.valueOf(index), (Tag)data);
        return tag;
    }

    public int getZ() {
        return this.z;
    }

    public int getX() {
        return this.x;
    }

    public int getChunkZ() {
        return SectionPos.blockToSectionCoord((int)this.z);
    }

    public int getChunkX() {
        return SectionPos.blockToSectionCoord((int)this.x);
    }

    public PathPos asPathPos() {
        return new PathPos(this.x, this.z);
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, 0, this.z);
    }

    public BlockPos asBlockPos(int y) {
        return new BlockPos(this.x, y, this.z);
    }

    public ChunkPos asChunkPos() {
        return new ChunkPos(this.asBlockPos());
    }

    public String toString() {
        return "X: " + this.x + "| Z: " + this.z;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathNode pathNode = (PathNode)o;
        return this.getX() == pathNode.getX() && this.getZ() == pathNode.getZ();
    }

    public int hashCode() {
        return Objects.hash(this.getX(), this.getZ());
    }
}

