/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.util;

import com.amber.roads.util.TravelersUtil;
import com.amber.roads.world.PathNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec2;

public enum TravelersDirection implements StringRepresentable
{
    N(0, 0.0f, -1.0f, "N"),
    NNE(1, 0.5f, -1.0f, "NNE"),
    NE(2, 1.0f, -1.0f, "NE"),
    ENE(3, 1.0f, -0.5f, "ENE"),
    E(4, 1.0f, 0.0f, "E"),
    ESE(5, 1.0f, 0.5f, "ESE"),
    SE(6, 1.0f, 1.0f, "SE"),
    SSE(7, 0.5f, 1.0f, "SSE"),
    S(8, 0.0f, 1.0f, "S"),
    SSW(9, -0.5f, 1.0f, "SSW"),
    SW(10, -1.0f, 1.0f, "SW"),
    WSW(11, -1.0f, 0.5f, "WSW"),
    W(12, -1.0f, 0.0f, "W"),
    WNW(13, -1.0f, -0.5f, "WNW"),
    NW(14, -1.0f, -1.0f, "NW"),
    NNW(15, -0.5f, -1.0f, "NNW");

    private final int index;
    private final float x;
    private final float z;
    private final String name;
    private static final int[][] indexByXZ;
    private static final TravelersDirection[] VALUES;
    private final Vec2 normal;

    private TravelersDirection(int index, float x, float z, String name) {
        this.index = index;
        this.x = x;
        this.z = z;
        this.name = name;
        this.normal = new Vec2(x, z);
    }

    public int getIndex() {
        return this.index;
    }

    public int getOppositeIndex() {
        return this.index > 7 ? this.index - 8 : this.index + 8;
    }

    public int getModifiedIndex(int modifier) {
        int newIndex = this.index + modifier;
        if (newIndex > 15) {
            newIndex -= 16;
        } else if (newIndex < 0) {
            newIndex += 16;
        }
        return newIndex;
    }

    public Collection<? extends TravelersDirection> getNeighbors() {
        return List.of(this, VALUES[this.getModifiedIndex(1)], VALUES[this.getModifiedIndex(-1)], VALUES[this.getModifiedIndex(2)], VALUES[this.getModifiedIndex(-2)]);
    }

    public float getStepX() {
        return this.normal.x;
    }

    public float getStepZ() {
        return this.normal.y;
    }

    public TravelersDirection getOpposite() {
        return VALUES[this.getOppositeIndex()];
    }

    public float getX() {
        return this.x;
    }

    public int nextPosX(int distance) {
        return Mth.floor((float)(this.getStepX() * (float)distance));
    }

    public int nextSectionCenterX(int distance) {
        return this.nextPosX(distance) / 2;
    }

    public float getZ() {
        return this.z;
    }

    public int nextPosZ(int distance) {
        return Mth.floor((float)(this.getStepZ() * (float)distance));
    }

    public int nextSectionCenterZ(int distance) {
        return this.nextPosZ(distance) / 2;
    }

    public PathNode nextPos(PathNode pos, int distance) {
        return new PathNode(pos.x + this.nextPosX(distance), pos.z + this.nextPosZ(distance), false);
    }

    public BlockPos nextSectionCenter(PathNode pos, int distance) {
        return new BlockPos(pos.x + this.nextSectionCenterX(distance), 0, pos.z + this.nextSectionCenterZ(distance));
    }

    public static TravelersDirection directionFromPos(PathNode pos1, PathNode pos2) {
        float max = Math.max(Math.abs(pos2.x - pos1.x), Math.abs(pos2.z - pos1.z));
        double x = Mth.clamp((float)TravelersUtil.roundToHalf((float)(pos2.x - pos1.x) / max), (float)-1.0f, (float)1.0f);
        double z = Mth.clamp((float)TravelersUtil.roundToHalf((float)(pos2.z - pos1.z) / max), (float)-1.0f, (float)1.0f);
        return VALUES[indexByXZ[(int)((x + 1.0) * 2.0)][(int)((z + 1.0) * 2.0)]];
    }

    public ArrayList<TravelersDirection> randomList() {
        ArrayList<TravelersDirection> list = this.narrowRandomList();
        int above2 = this.getModifiedIndex(2);
        int below2 = this.getModifiedIndex(-2);
        list.add(VALUES[above2]);
        list.add(VALUES[below2]);
        return list;
    }

    public ArrayList<TravelersDirection> narrowRandomList() {
        ArrayList<TravelersDirection> list = new ArrayList<TravelersDirection>();
        int above = this.getModifiedIndex(1);
        int below = this.getModifiedIndex(-1);
        list.add(this);
        list.add(VALUES[above]);
        list.add(VALUES[below]);
        return list;
    }

    public static TravelersDirection getRandom(RandomSource random) {
        return TravelersDirection.values()[random.nextInt(8)];
    }

    public static TravelersDirection getRandomList(RandomSource random, ArrayList<TravelersDirection> weightedList) {
        return weightedList.get(random.nextInt(weightedList.size()));
    }

    public TravelersDirection getRandomForDirection(RandomSource random) {
        return TravelersDirection.getRandomList(random, this.randomList());
    }

    public static TravelersDirection getRandomNarrowList(RandomSource random, ArrayList<TravelersDirection> weightedNarrowList) {
        return weightedNarrowList.get(random.nextInt(weightedNarrowList.size()));
    }

    public TravelersDirection getRandomNarrowForDirection(RandomSource random) {
        return TravelersDirection.getRandomNarrowList(random, this.narrowRandomList());
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        indexByXZ = new int[][]{{14, 13, 12, 11, 10}, {15, -1, -1, -1, 9}, {0, -1, -1, -1, 8}, {1, -1, -1, -1, 7}, {2, 3, 4, 5, 6}};
        VALUES = TravelersDirection.values();
    }
}

