/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.util;

import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum PathSize implements StringRepresentable
{
    MINI("MINI", 1),
    SMALL("SMALL", 2),
    MEDIUM("MEDIUM", 3),
    LARGE("LARGE", 4);

    private final int width;
    private final int extraWidth;
    private final int distance;
    private final int nodesPerImportantNode;
    private final String name;

    private PathSize(String name, int width) {
        this.width = width;
        this.extraWidth = width + 2;
        this.name = name;
        this.distance = Math.round(0.667f * (float)(width * width) - (float)width + 5.333f);
        this.nodesPerImportantNode = 80 / this.distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getWidth() {
        return this.width;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }

    public int getNodesPerImportantNode() {
        return this.nodesPerImportantNode;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }
}

