/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.util;

import com.amber.roads.world.PathNode;
import com.amber.roads.world.TravelersPath;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CrossroadsData
extends SavedData {
    private ArrayList<TravelersPath> unfinishedPaths = new ArrayList();
    private ArrayList<PathNode> pathNodes = new ArrayList();

    public static CrossroadsData create() {
        return new CrossroadsData();
    }

    public static CrossroadsData instance(DimensionDataStorage storage) {
        return (CrossroadsData)storage.computeIfAbsent(new SavedData.Factory(CrossroadsData::create, CrossroadsData::load), "path_data");
    }

    public static CrossroadsData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        CrossroadsData data = CrossroadsData.create();
        int length = tag.getInt("paths");
        for (int i = 0; i < length; ++i) {
            data.unfinishedPaths.add(new TravelersPath(tag, i));
        }
        int nodes_len = tag.getInt("nodes");
        for (int i = 0; i < nodes_len; ++i) {
            data.pathNodes.add(new PathNode((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)("node" + i)).orElseThrow()));
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        int i;
        tag.putInt("paths", this.unfinishedPaths.size());
        for (i = 0; i < this.unfinishedPaths.size(); ++i) {
            TravelersPath path = this.unfinishedPaths.get(i);
            path.save(tag, i);
        }
        tag.putInt("nodes", this.pathNodes.size());
        for (i = 0; i < this.pathNodes.size(); ++i) {
            tag.put("node" + i, NbtUtils.writeBlockPos((BlockPos)this.pathNodes.get(i).asBlockPos()));
        }
        return tag;
    }

    public ArrayList<TravelersPath> getUnfinishedPaths() {
        return this.unfinishedPaths;
    }

    public ArrayList<PathNode> getPathNodes() {
        return this.pathNodes;
    }

    public boolean addPath(TravelersPath newPath) {
        if (this.unfinishedPaths.contains(newPath)) {
            return false;
        }
        this.unfinishedPaths.add(newPath);
        this.setDirty();
        return true;
    }

    public void addPathNode(PathNode node) {
        if (this.pathNodes.contains(node)) {
            return;
        }
        this.pathNodes.add(node);
        this.setDirty();
    }

    public void checkPaths() {
        this.unfinishedPaths.removeIf(TravelersPath::completed);
    }

    public void removePath(TravelersPath path) {
        this.unfinishedPaths.remove(path);
        this.setDirty();
    }

    public void removePathNode(PathNode node) {
        this.pathNodes.remove(node);
        this.setDirty();
    }
}

