/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.init;

import com.amber.roads.block.CairnBlock;
import com.amber.roads.init.TravelersRegistries;
import com.amber.roads.worldgen.TravelersStart;
import com.amber.roads.worldgen.custom.DistanceFilter;
import com.amber.roads.worldgen.custom.OffsetModifier;
import com.amber.roads.worldgen.custom.PathModifiers;
import com.amber.roads.worldgen.custom.pathstyle.PathStyle;
import com.amber.roads.worldgen.custom.pathstyle.PercentStyle;
import com.amber.roads.worldgen.custom.pathstyle.SparseStyle;
import com.amber.roads.worldgen.custom.pathstyle.StyleModifierType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TravelersInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"travelers_crossroads");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"travelers_crossroads");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"travelers_crossroads");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"travelers_crossroads");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"travelers_crossroads");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENTS = DeferredRegister.create((ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE, (String)"travelers_crossroads");
    public static final DeferredRegister<StyleModifierType<?>> STYLE_MODIFIER_SERIALIZERS = DeferredRegister.create(TravelersRegistries.PATH_STYLE_TYPE, (String)"travelers_crossroads");
    public static final DeferredRegister<MapCodec<? extends OffsetModifier>> OFFSET_MODIFIER_SERIALIZERS = DeferredRegister.create(TravelersRegistries.STRUCTURE_OFFSET_SERIALIZERS, (String)"travelers_crossroads");
    public static final Supplier<Block> CAIRN = TravelersInit.registerBlock("cairn", () -> new CairnBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRAVEL).forceSolidOn()));
    public static final Supplier<Item> PEBBLE = ITEMS.register("pebble", () -> new Item(new Item.Properties().stacksTo(24)));
    public static final Supplier<CreativeModeTab> TRAVELERS_TAB = CREATIVE_MODE_TABS.register("travelers_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.travelers_crossroads.travelers_tab")).icon(() -> new ItemStack((ItemLike)CAIRN.get())).displayItems((pParameters, pOutput) -> pOutput.accept((ItemLike)CAIRN.get())).build());
    public static final Supplier<Feature<NoneFeatureConfiguration>> TRAVELERS_BEGINNING = TravelersInit.registerFeature("travelers_beginning", () -> new TravelersStart((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<PlacementModifierType<?>, PlacementModifierType<DistanceFilter>> DISTANCE_FILTER = PLACEMENTS.register("distance_filter", () -> TravelersInit.explicitPlacmentTypeTyping(DistanceFilter.CODEC));
    public static final DeferredHolder<StyleModifierType<?>, StyleModifierType<PercentStyle>> PERCENT_STYLE = STYLE_MODIFIER_SERIALIZERS.register("percent_style", () -> TravelersInit.explicitPathStyleTypeTyping(PercentStyle.CODEC));
    public static final DeferredHolder<StyleModifierType<?>, StyleModifierType<SparseStyle>> SPARSE_STYLE = STYLE_MODIFIER_SERIALIZERS.register("sparse_style", () -> TravelersInit.explicitPathStyleTypeTyping(SparseStyle.CODEC));
    public static final DeferredHolder<MapCodec<? extends OffsetModifier>, MapCodec<PathModifiers.DistanceModifier>> DISTANCE_OFFSET_MODIFIER_TYPE = OFFSET_MODIFIER_SERIALIZERS.register("distance_offset_modifier", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).fieldOf("structures").forGetter(PathModifiers.DistanceModifier::structures), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("offset").forGetter(PathModifiers.DistanceModifier::offset)).apply((Applicative)builder, PathModifiers.DistanceModifier::new)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = (DeferredBlock)BLOCKS.register(name, block);
        TravelersInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Feature<?>> Supplier<T> registerFeature(String name, Supplier<T> feature) {
        return FEATURES.register(name, feature);
    }

    private static <T extends PlacementModifier> PlacementModifierType<T> explicitPlacmentTypeTyping(MapCodec<T> placementTypeCodec) {
        return () -> placementTypeCodec;
    }

    private static <T extends PathStyle> StyleModifierType<T> explicitPathStyleTypeTyping(MapCodec<T> pathStyleTypeCodec) {
        return () -> pathStyleTypeCodec;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
        FEATURES.register(eventBus);
        PLACEMENTS.register(eventBus);
        STYLE_MODIFIER_SERIALIZERS.register(eventBus);
        OFFSET_MODIFIER_SERIALIZERS.register(eventBus);
    }
}

