/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.datagen;

import com.amber.roads.datagen.TravelersBiomeTagProvider;
import com.amber.roads.datagen.TravelersBlockTagProvider;
import com.amber.roads.datagen.TravelersLootTableProvider;
import com.amber.roads.datagen.TravelersRecipeProvider;
import com.amber.roads.datagen.TravelersStructureTagProvider;
import com.amber.roads.datagen.TravelersWorldGenProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="travelers_crossroads", bus=EventBusSubscriber.Bus.MOD)
public class TravelersDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new TravelersRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TravelersLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new TravelersBlockTagProvider(packOutput, lookupProvider, "travelers_crossroads", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TravelersStructureTagProvider(packOutput, lookupProvider, "travelers_crossroads", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TravelersBiomeTagProvider(packOutput, lookupProvider, "travelers_crossroads", existingFileHelper));
        TravelersWorldGenProvider datapackprovider = new TravelersWorldGenProvider(packOutput, lookupProvider);
        generator.addProvider(event.includeServer(), (DataProvider)datapackprovider);
    }
}

