/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads.block;

import com.amber.roads.util.TravelersUtil;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CairnBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final MapCodec<CairnBlock> CODEC = CairnBlock.simpleCodec(CairnBlock::new);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)8.0, (double)9.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)8.0), Block.box((double)3.0, (double)0.0, (double)5.0, (double)9.0, (double)1.0, (double)9.0), Block.box((double)8.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)1.0, (double)4.25, (double)7.0, (double)2.0, (double)7.25), Block.box((double)8.0, (double)1.0, (double)7.75, (double)11.0, (double)2.0, (double)10.75), Block.box((double)4.5, (double)1.0, (double)8.25, (double)7.5, (double)2.0, (double)11.25), Block.box((double)7.0, (double)1.0, (double)4.75, (double)10.0, (double)2.0, (double)7.75), Block.box((double)7.5, (double)2.0, (double)7.25, (double)10.0, (double)3.0, (double)9.75), Block.box((double)5.5, (double)2.0, (double)5.25, (double)8.0, (double)3.0, (double)7.75), Block.box((double)5.0, (double)2.0, (double)7.75, (double)7.5, (double)3.0, (double)10.25), Block.box((double)6.5, (double)3.0, (double)6.75, (double)9.0, (double)4.0, (double)9.25), Block.box((double)6.1, (double)4.0, (double)7.15, (double)8.6, (double)5.0, (double)9.65), Block.box((double)6.6, (double)5.0, (double)7.65, (double)8.1, (double)5.75, (double)9.15)});

    public CairnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getRotatedShape(state, level, pos);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state, level, pos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state, level, pos);
    }

    protected VoxelShape getRotatedShape(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue((Property)FACING) == Direction.SOUTH ? SHAPE : TravelersUtil.rotateShape(Direction.SOUTH, (Direction)state.getValue((Property)FACING), SHAPE);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.mirror(mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, Direction.UP);
    }
}

