/*
 * Decompiled with CFR 0.152.
 */
package com.amber.roads;

import com.amber.roads.TravelersConfig;
import com.amber.roads.init.TravelersInit;
import com.amber.roads.init.TravelersRegistries;
import com.amber.roads.worldgen.TravelersWatcher;
import com.amber.roads.worldgen.custom.OffsetModifier;
import com.amber.roads.worldgen.custom.pathstyle.PathStyle;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.slf4j.Logger;

@Mod(value="travelers_crossroads")
public class TravelersCrossroads {
    public static final String MOD_ID = "travelers_crossroads";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TravelersWatcher WATCHER = new TravelersWatcher();

    public TravelersCrossroads(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        TravelersInit.register(modEventBus);
        modEventBus.addListener(this::registerDatapackRegistries);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TravelersConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(TravelersRegistries.Keys.PATH_STYLES, PathStyle.DIRECT_CODEC);
        event.dataPackRegistry(TravelersRegistries.Keys.STRUCTURE_OFFSETS, OffsetModifier.DIRECT_CODEC);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        WATCHER.setPathData();
    }

    @SubscribeEvent
    public void serverStarting(ServerAboutToStartEvent event) {
        WATCHER.setServer(event.getServer());
        LOGGER.debug("ServerAboutToStart");
    }

    public static ResourceLocation travelersLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @EventBusSubscriber(modid="travelers_crossroads", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

