/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;

public class PacketCreateCart
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketCreateCart> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"create_cart"));
    private final BlockPos blockPos;
    private final int id;
    private final byte[] data;

    public PacketCreateCart(BlockPos blockPos, int id, byte[] data) {
        this.blockPos = blockPos;
        this.id = id;
        this.data = data;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.id);
        buf.writeByteArray(this.data);
    }

    public static PacketCreateCart read(FriendlyByteBuf buffer) {
        return new PacketCreateCart(buffer.readBlockPos(), buffer.readInt(), buffer.readByteArray());
    }

    public static class Handler
    implements IPayloadHandler<PacketCreateCart> {
        public void handle(PacketCreateCart msg, IPayloadContext ctx) {
            if (ctx.flow() != PacketFlow.SERVERBOUND) {
                return;
            }
            ctx.enqueueWork(() -> {
                Player patt0$temp;
                if (msg.blockPos != null && (patt0$temp = ctx.player()) instanceof ServerPlayer) {
                    BlockEntity patt1$temp;
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    BlockPos blockPos = msg.blockPos;
                    if (player.level().isLoaded(blockPos) && (patt1$temp = player.level().getBlockEntity(blockPos)) instanceof TileEntityCartAssembler) {
                        TileEntityCartAssembler tileEntityCartAssembler = (TileEntityCartAssembler)patt1$temp;
                        tileEntityCartAssembler.receivePacket(msg.id, msg.data, player);
                    }
                }
            });
        }
    }
}

