/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.containers.slots.SlotCakeDynamite;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.realtimers.ModuleCakeServer;

public class ModuleCakeServerDynamite
extends ModuleCakeServer {
    private int dynamiteCount;

    private int getMaxDynamiteCount() {
        return Math.min((Integer)SCConfig.COMMON.maxDynamites.get(), 25);
    }

    public ModuleCakeServerDynamite(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotCakeDynamite(this.getCart(), slotId, 8 + x * 18, 38 + y * 18);
    }

    @Override
    public boolean dropOnDeath() {
        return this.dynamiteCount == 0;
    }

    @Override
    public void onDeath() {
        if (this.dynamiteCount > 0) {
            this.explode();
        }
    }

    private void explode() {
        this.getCart().level().explode(null, (double)this.getCart().getExactPosition().getX(), (double)this.getCart().getExactPosition().getY(), (double)this.getCart().getExactPosition().getZ(), (float)this.dynamiteCount * 0.08f, Level.ExplosionInteraction.NONE);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().level().isClientSide) {
            ItemStack itemStack = this.getStack(0);
        }
    }

    @Override
    public boolean onInteractFirst(Player entityplayer) {
        if (this.dynamiteCount > 0) {
            this.explode();
            this.getCart().remove(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.onInteractFirst(entityplayer);
    }
}

