/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotCartCrafter;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.RecipeHelper;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleCrafter
extends ModuleRecipe {
    private int cooldown = 0;

    public ModuleCrafter(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.cooldown <= 0) {
            ItemStack result;
            if (!this.getCart().level().isClientSide && this.getValidSlot() != null && !(result = this.getResult()).isEmpty() && this.getCart().getModules() != null) {
                if (result.getCount() == 0) {
                    result.setCount(1);
                }
                this.prepareLists();
                if (this.canCraftMoreOfResult(result)) {
                    int j;
                    NonNullList originals = NonNullList.create();
                    for (int i = 0; i < this.allTheSlots.size(); ++i) {
                        ItemStack item = ((SlotStevesCarts)((Object)this.allTheSlots.get(i))).getItem();
                        originals.add((Object)(item.isEmpty() ? ItemStack.EMPTY : item.copy()));
                    }
                    ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
                    boolean valid = true;
                    boolean edited = false;
                    for (j = 0; j < 9; ++j) {
                        ItemStack recipe = this.getStack(j);
                        if (recipe.isEmpty()) continue;
                        valid = false;
                        for (int k = 0; k < this.inputSlots.size(); ++k) {
                            ItemStack item2 = ((SlotStevesCarts)((Object)this.inputSlots.get(k))).getItem();
                            if (item2.isEmpty() || !ItemStack.isSameItem((ItemStack)item2, (ItemStack)recipe) || !ItemStack.isSameItemSameComponents((ItemStack)item2, (ItemStack)recipe)) continue;
                            edited = true;
                            if (item2.hasCraftingRemainingItem()) {
                                containers.add(item2.getItem().getCraftingRemainingItem(item2));
                            }
                            ItemStack itemStack = item2;
                            itemStack.shrink(1);
                            if (item2.getCount() <= 0) {
                                ((SlotStevesCarts)((Object)this.inputSlots.get(k))).set(ItemStack.EMPTY);
                            }
                            valid = true;
                            break;
                        }
                        if (!valid) break;
                    }
                    if (valid && this.getValidSlot() != null) {
                        this.getCart().addItemToChest(result, this.getValidSlot(), null);
                        if (result.getCount() > 0) {
                            valid = false;
                        } else {
                            edited = true;
                            for (j = 0; j < containers.size(); ++j) {
                                ItemStack container = (ItemStack)containers.get(j);
                                if (container == null) continue;
                                this.getCart().addItemToChest(container, this.getValidSlot(), null);
                                if (container.getCount() <= 0) continue;
                                valid = false;
                                break;
                            }
                        }
                    }
                    if (!valid && edited) {
                        for (j = 0; j < this.allTheSlots.size(); ++j) {
                            ((SlotStevesCarts)((Object)this.allTheSlots.get(j))).set((ItemStack)originals.get(j));
                        }
                    }
                }
            }
            this.cooldown = 40;
        } else {
            --this.cooldown;
        }
    }

    @Nullable
    public CraftingRecipe getRecipe() {
        CraftingInput input = CraftingInput.of((int)3, (int)3, (List)Lists.newArrayList((Object[])new ItemStack[]{this.getStack(0), this.getStack(1), this.getStack(2), this.getStack(3), this.getStack(4), this.getStack(5), this.getStack(6), this.getStack(7), this.getStack(8)}));
        return RecipeHelper.findRecipe(RecipeType.CRAFTING, input, this.getCart().level()).map(RecipeHolder::value).orElse(null);
    }

    @NotNull
    public ItemStack getResult() {
        CraftingRecipe recipe = this.getRecipe();
        if (recipe != null) {
            return recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected int[] getArea() {
        return new int[]{68, 44, 16, 16};
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public int generateSlots(int slotCount) {
        this.slotGlobalStart = slotCount;
        this.slotList = new ArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.slotList.add(new SlotCartCrafter(this.getCart(), slotCount++, 10 + 18 * x, 15 + 18 * y));
            }
        }
        this.slotList.add(new SlotCartCrafterResult(this.getCart(), slotCount++, 67, this.canUseAdvancedFeatures() ? 20 : 33));
        return slotCount;
    }

    @Override
    public void onInventoryChanged() {
        if (this.getCart().level().isClientSide) {
            this.setStack(9, this.getResult() == null ? ItemStack.EMPTY : this.getResult());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        super.drawForeground(guiGraphics, gui);
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 120 : 95;
    }

    @Override
    public int guiHeight() {
        return 75;
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected int getLimitStartX() {
        return 90;
    }

    @Override
    protected int getLimitStartY() {
        return 23;
    }
}

