/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.common.lib.Color;
import mekanism.generators.common.tile.fission.TileEntityFissionAssembly;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@NothingNullByDefault
public class FuelAssemblyBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final Color GLOW_ARGB = Color.rgbad((double)0.466, (double)0.882, (double)0.929, (double)0.6);
    private static final Vector3f NORTH_EAST = new Vector3f(0.95f, 0.125f, 0.05f);
    private static final Vector3f SOUTH_WEST = new Vector3f(0.05f, 0.125f, 0.95f);
    private final Map<Direction, List<BakedQuad>> cachedGlows = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
    @Nullable
    private ChunkRenderTypeSet renderTypes;
    private final float height;

    public FuelAssemblyBakedModel(BakedModel original, float height) {
        super(original);
        this.height = height;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        List quads = super.getQuads(state, side, rand, data, renderType);
        if (side != null && side.getAxis().isHorizontal() && renderType == RenderType.translucent() && data.has(TileEntityFissionAssembly.GLOWING)) {
            List<BakedQuad> allQuads = this.cachedGlows.get(side);
            if (allQuads == null) {
                Vector3f startPos = switch (side) {
                    case Direction.NORTH, Direction.EAST -> NORTH_EAST;
                    case Direction.SOUTH, Direction.WEST -> SOUTH_WEST;
                    default -> throw new IllegalStateException("Unexpected face");
                };
                Quad.Builder quadBuilder = new Quad.Builder(MekanismRenderer.whiteIcon, side).light(240, 0xF00000).uv(0.0f, 0.0f, 16.0f, 16.0f).color(GLOW_ARGB).rect(startPos, 0.9f, this.height, 1.0f);
                allQuads = List.of(quadBuilder.build().bake());
                this.cachedGlows.put(side, allQuads);
            }
            if (quads.isEmpty()) {
                return allQuads;
            }
            ArrayList<BakedQuad> mergedQuads = new ArrayList<BakedQuad>(quads);
            mergedQuads.addAll(allQuads);
            return mergedQuads;
        }
        return quads;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (data.has(TileEntityFissionAssembly.GLOWING)) {
            if (this.renderTypes == null) {
                this.renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{super.getRenderTypes(state, rand, data), ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.translucent()})});
            }
            return this.renderTypes;
        }
        return super.getRenderTypes(state, rand, data);
    }
}

