/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.EnumSet;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSyncClassifyFilter(boolean matchAll, EnumSet<ClassifyFilterItem.FilterCondition> conditions, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSyncClassifyFilter> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("sync_classify_filter"));
    private static final StreamCodec<FriendlyByteBuf, EnumSet<ClassifyFilterItem.FilterCondition>> FILTER_SET = StreamCodec.of((buf, filterSet) -> buf.writeEnumSet(filterSet, ClassifyFilterItem.FilterCondition.class), buf -> buf.readEnumSet(ClassifyFilterItem.FilterCondition.class));
    public static final StreamCodec<FriendlyByteBuf, PacketSyncClassifyFilter> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, PacketSyncClassifyFilter::matchAll, FILTER_SET, PacketSyncClassifyFilter::conditions, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketSyncClassifyFilter::hand, PacketSyncClassifyFilter::new);

    public CustomPacketPayload.Type<PacketSyncClassifyFilter> type() {
        return TYPE;
    }

    public static void handle(PacketSyncClassifyFilter message, IPayloadContext ctx) {
        ItemStack stack = ctx.player().getItemInHand(message.hand());
        if (stack.getItem() instanceof ClassifyFilterItem) {
            new ClassifyFilterItem.FilterSettings(message.matchAll(), message.conditions().stream().toList()).save(stack);
        }
    }
}

