/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketHackingEntityStart(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketHackingEntityStart> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("hack_entity_start"));
    public static final StreamCodec<FriendlyByteBuf, PacketHackingEntityStart> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketHackingEntityStart::entityId, PacketHackingEntityStart::new);

    public CustomPacketPayload.Type<PacketHackingEntityStart> type() {
        return TYPE;
    }

    public static void handle(PacketHackingEntityStart message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (ctx.flow().isClientbound()) {
            Entity entity = player.level().getEntity(message.entityId());
            if (entity != null) {
                CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(entity);
                ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == entity).findFirst().ifPresent(RenderEntityTarget::onHackConfirmServer);
            }
        } else if (player instanceof ServerPlayer) {
            Entity entity;
            ServerPlayer sp = (ServerPlayer)player;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true) && (entity = player.level().getEntity(message.entityId())) != null) {
                handler.getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(entity);
                NetworkHandler.sendToPlayer(message, sp);
            }
        }
    }
}

