/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.fluid.PNCFluidRenderProps;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class FluidPlastic {
    public static final PNCFluidRenderProps RENDER_PROPS = new PNCFluidRenderProps("plastic_still", "plastic_flow");

    private static BaseFlowingFluid.Properties props() {
        return new BaseFlowingFluid.Properties(ModFluids.PLASTIC_FLUID_TYPE, ModFluids.PLASTIC, ModFluids.PLASTIC_FLOWING).block(ModBlocks.PLASTIC).bucket(ModItems.PLASTIC_BUCKET).tickRate(10);
    }

    public static class Bucket
    extends PneumaticCraftBucketItem
    implements ICustomTooltipName {
        public Bucket() {
            super((Fluid)ModFluids.PLASTIC.get());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return (Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get() != false ? this.getDescriptionId() : this.getDescriptionId() + ".not_in_world";
        }
    }

    public static class Flowing
    extends BaseFlowingFluid.Flowing {
        public Flowing() {
            super(FluidPlastic.props());
        }
    }

    public static class Source
    extends BaseFlowingFluid.Source {
        public Source() {
            super(FluidPlastic.props());
        }

        public void tick(Level worldIn, BlockPos pos, FluidState state) {
            if (((Boolean)ConfigHelper.common().recipes.inWorldPlasticSolidification.get()).booleanValue()) {
                ItemEntity item = new ItemEntity(worldIn, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.PLASTIC.get()));
                worldIn.addFreshEntity((Entity)item);
                worldIn.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
            super.tick(worldIn, pos, state);
        }
    }
}

