/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.recipes.VanillaRecipeCache;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class HeatFrameEntity
extends AbstractSemiblockEntity {
    private static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.defineId(HeatFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> TEMPERATURE = SynchedEntityData.defineId(HeatFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MIN_COOKING_TEMP = 373;
    private static final byte IDLE = 0;
    private static final byte COOKING = 1;
    private static final byte COOLING = 2;
    private final IHeatExchangerLogic logic = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private int lastValidSlot;
    private int cookingProgress;
    private int coolingProgress;
    private final SyncedTemperature syncedTemperature = new SyncedTemperature(this.logic);

    public HeatFrameEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public IHeatExchangerLogic getHeatExchangerLogic() {
        return this.logic;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATUS, (Object)0);
        builder.define(TEMPERATURE, (Object)0);
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockEntity te = this.getCachedTileEntity();
        return te != null && IOHelper.getInventoryForBlock(te).isPresent() && IOHelper.getFluidHandlerForBlock(te).isEmpty();
    }

    private void setStatus(byte status) {
        this.getEntityData().set(STATUS, (Object)status);
    }

    private byte getStatus() {
        return (Byte)this.getEntityData().get(STATUS);
    }

    private void setSyncedTemperature(int temperature) {
        this.getEntityData().set(TEMPERATURE, (Object)temperature);
    }

    public int getSyncedTemperature() {
        return (Integer)this.getEntityData().get(TEMPERATURE);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            this.logic.initializeAmbientTemperature(this.level(), this.getBlockPos());
        }
        if (!this.getWorld().isClientSide) {
            byte newStatus = 0;
            if (this.logic.getTemperature() > 373.0) {
                newStatus = this.doCooking();
            } else if (this.logic.getTemperature() < (double)HeatFrameCoolingRecipeImpl.getMaxThresholdTemp(this.getWorld())) {
                newStatus = this.doCooling();
            }
            this.setStatus(newStatus);
            if (newStatus == 0) {
                double delta = this.logic.getTemperature() - this.logic.getAmbientTemperature();
                if (delta > 1.0) {
                    this.logic.addHeat(-0.1);
                } else if (delta < -1.0) {
                    this.logic.addHeat(0.1);
                }
            }
            this.syncedTemperature.tick();
            this.setSyncedTemperature(this.syncedTemperature.getSyncedTemp());
        } else if ((this.tickCount & 3) == 0) {
            byte status = this.getStatus();
            switch (status) {
                case 1: {
                    ClientUtils.emitParticles(this.level(), this.getBlockPos(), (ParticleOptions)(this.level().random.nextInt(4) == 0 ? ParticleTypes.FLAME : ParticleTypes.SMOKE));
                    break;
                }
                case 2: {
                    ClientUtils.emitParticles(this.level(), this.getBlockPos(), (ParticleOptions)ParticleTypes.SPIT);
                }
            }
        }
    }

    private byte doCooking() {
        byte newStatus = 0;
        if (this.cookingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 343) / 30);
            progress = Math.min(5, progress);
            this.logic.addHeat(-progress);
            this.cookingProgress += progress;
            newStatus = 1;
        }
        if (this.cookingProgress >= 100) {
            IOHelper.getInventoryForBlock(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCookSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCookSlot((IItemHandler)handler, i)) continue;
                        this.cookingProgress -= 100;
                        break;
                    }
                } else {
                    this.cookingProgress -= 100;
                }
            });
        }
        return newStatus;
    }

    private boolean tryCookSlot(IItemHandler handler, int slot) {
        ItemStack stack;
        if (slot >= 0 & slot < handler.getSlots() && !(stack = handler.getStackInSlot(slot)).isEmpty()) {
            return VanillaRecipeCache.SMELTING.getCachedRecipe(this.level(), new SingleRecipeInput(stack)).map(recipe -> {
                ItemStack remainder;
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.level().registryAccess()).copy();
                if (!result.isEmpty() && (remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)true)).isEmpty()) {
                    handler.extractItem(slot, 1, false);
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                    this.lastValidSlot = slot;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private byte doCooling() {
        int newStatus = 0;
        if (this.coolingProgress < 100) {
            int progress = Math.max(0, ((int)this.logic.getTemperature() - 243) / 30);
            progress = 6 - Math.min(5, progress);
            this.logic.addHeat(progress);
            this.coolingProgress += progress;
            newStatus = 2;
        }
        if (this.coolingProgress >= 100) {
            IOHelper.getInventoryForBlock(this.getCachedTileEntity()).ifPresent(handler -> {
                if (!this.tryCoolSlot((IItemHandler)handler, this.lastValidSlot)) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (!this.tryCoolSlot((IItemHandler)handler, i)) continue;
                        this.coolingProgress -= 100;
                        break;
                    }
                } else {
                    this.coolingProgress -= 100;
                }
            });
        }
        return (byte)newStatus;
    }

    private boolean tryCoolSlot(IItemHandler handler, int slot) {
        if (slot >= 0 & slot < handler.getSlots()) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.isEmpty()) {
                return false;
            }
            return ModRecipeTypes.HEAT_FRAME_COOLING.get().findFirst(this.level(), r -> r.matches(stack)).map(holder -> {
                HeatFrameCoolingRecipe recipe = (HeatFrameCoolingRecipe)holder.value();
                boolean extractedOK = (Boolean)recipe.getInput().map(ingredient -> handler.extractItem(slot, 1, false).getCount() == 1, fluidIngredient -> {
                    if (stack.getCount() != 1) {
                        return false;
                    }
                    return IOHelper.getFluidHandlerForItem(stack).map(fluidHandler -> {
                        int toDrain = fluidIngredient.amount();
                        if (fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount() == toDrain) {
                            ItemStack containerStack = fluidHandler.getContainer().copy();
                            handler.extractItem(slot, 1, false);
                            handler.insertItem(slot, containerStack, false);
                            return true;
                        }
                        return false;
                    }).orElse(false);
                });
                if (extractedOK) {
                    ItemStack result = recipe.getOutput().copyWithCount(recipe.calculateOutputQuantity(this.logic.getTemperature()));
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)result, (boolean)false);
                    this.lastValidSlot = slot;
                }
                return extractedOK;
            }).orElse(false);
        }
        return false;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.logic.deserializeNBT(tag.getCompound("heatExchanger"));
        this.cookingProgress = tag.getInt("cookingProgress");
        this.coolingProgress = tag.getInt("coolingProgress");
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("heatExchanger", (Tag)this.logic.serializeNBT());
        tag.putInt("cookingProgress", this.cookingProgress);
        tag.putInt("coolingProgress", this.coolingProgress);
        return super.serializeNBT(tag, provider);
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        int cool;
        int cook;
        if (!this.level().isClientSide) {
            cook = this.cookingProgress;
            cool = this.coolingProgress;
        } else {
            this.logic.deserializeNBT(tag.getCompound("heatExchanger"));
            cook = tag.getInt("cookingProgress");
            cool = tag.getInt("coolingProgress");
        }
        if (this.getStatus() != 1 && cook >= 100) {
            cook = 0;
        }
        if (this.getStatus() != 2 && cool >= 100) {
            cool = 0;
        }
        curInfo.accept(HeatUtil.formatHeatString(this.logic.getTemperatureAsInt()));
        if (cook != 0) {
            curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooking", cook).withStyle(ChatFormatting.GRAY));
        }
        if (cool != 0) {
            curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.heatFrame.cooling", cool).withStyle(ChatFormatting.GRAY));
        }
    }
}

