/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIEnergyImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetEnergyImport
extends ProgWidgetInventoryBase {
    public static final MapCodec<ProgWidgetEnergyImport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetEnergyImport.invParts(builder).apply((Applicative)builder, ProgWidgetEnergyImport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetEnergyImport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetEnergyImport::new);

    public ProgWidgetEnergyImport() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
    }

    public ProgWidgetEnergyImport(ProgWidget.PositionFields positionFields, ProgWidgetInventoryBase.InvBaseFields invBaseFields) {
        super(positionFields, invBaseFields);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetEnergyImport(this.getPosition(), this.invBaseFields().copy());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.RF_IMPORT.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIEnergyImport(drone, (ProgWidgetInventoryBase)widget);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_RF_IMPORT;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.BLUE;
    }
}

