/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.AerialInterfaceMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.curios.CuriosUtils;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.WildcardedRLMatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;

public class AerialInterfaceBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<AerialInterfaceBlockEntity>,
IComparatorSupport,
ISideConfigurable,
MenuProvider {
    private static final UUID NO_PLAYER = new UUID(0L, 0L);
    private static final int ENERGY_CAPACITY = 100000;
    private static final int RF_PER_TICK = 1000;
    private static final int PLAYER_AIR_MULTIPLIER = 5;
    private static final List<RedstoneController.RedstoneMode<AerialInterfaceBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<AerialInterfaceBlockEntity>("standard.never", new ItemStack((ItemLike)Items.GUNPOWDER), te -> false), new RedstoneController.EmittingRedstoneMode<AerialInterfaceBlockEntity>("aerialInterface.playerConnected", new ItemStack((ItemLike)ModBlocks.AERIAL_INTERFACE.get()), te -> te.isConnectedToPlayer));
    private static final String NO_AERIAL_INTERFACE = "pneumaticcraft:no_aerial_interface";
    private static final Lazy<WildcardedRLMatcher> dimensionBlacklist = WildcardedRLMatcher.lazyFromConfig(ConfigHelper.common().machines.aerialInterfaceDimensionBlacklist);
    @DescSynced
    private String playerName = "";
    private UUID playerUUID = NO_PLAYER;
    private Fluid curXpFluid = Fluids.EMPTY;
    private int curXpRatio = 0;
    @GuiSynced
    public int curXPFluidIndex = -1;
    @GuiSynced
    public FeedMode feedMode = FeedMode.FRUGAL;
    private boolean oldRedstoneStatus;
    private boolean needUpdateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer = false;
    @GuiSynced
    public boolean dispenserUpgradeInserted;
    @GuiSynced
    private final RedstoneController<AerialInterfaceBlockEntity> rsController = new RedstoneController<AerialInterfaceBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    public OperatingProblem operatingProblem = OperatingProblem.OK;
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private final PlayerExperienceHandler playerExperienceHandler = new PlayerExperienceHandler();
    private final PlayerFoodHandler playerFoodHandler = new PlayerFoodHandler();
    private final PneumaticEnergyStorage energyStorage = new PneumaticEnergyStorage(100000);
    private WeakReference<Player> playerRef = new WeakReference<Object>(null);
    private final IntList chargeableSlots = new IntArrayList();
    private final List<PlayerInvHandler> invHandlers = new ArrayList<PlayerInvHandler>();
    public GameProfile gameProfileClient;
    private boolean validatePlayerNow;

    public AerialInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.AERIAL_INTERFACE.get(), pos, state, PressureTier.TIER_TWO, 4000, 4);
        PlayerMainInvHandler playerMainInvHandler = new PlayerMainInvHandler(this);
        PlayerArmorInvHandler playerArmorInvHandler = new PlayerArmorInvHandler(this);
        PlayerOffhandInvHandler playerOffhandInvHandler = new PlayerOffhandInvHandler(this);
        PlayerEnderInvHandler playerEnderInvHandler = new PlayerEnderInvHandler(this);
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("mainInv", new ItemStack((ItemLike)Blocks.CHEST), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> playerMainInvHandler, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("armorInv", new ItemStack((ItemLike)ModItems.PNEUMATIC_CHESTPLATE.get()), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> playerArmorInvHandler, SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.registerHandler("offhandInv", new ItemStack((ItemLike)Items.SHIELD), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> playerOffhandInvHandler, new SideConfigurator.RelativeFace[0]);
        this.itemHandlerSideConfigurator.registerHandler("enderInv", new ItemStack((ItemLike)Blocks.ENDER_CHEST), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> playerEnderInvHandler, new SideConfigurator.RelativeFace[0]);
        this.invHandlers.add(playerMainInvHandler);
        this.invHandlers.add(playerArmorInvHandler);
        this.invHandlers.add(playerOffhandInvHandler);
        this.invHandlers.add(playerEnderInvHandler);
        if (Curios.available) {
            PlayerCuriosHandler playerCuriosHandler = new PlayerCuriosHandler(this);
            this.itemHandlerSideConfigurator.registerHandler("curiosInv", new ItemStack((ItemLike)Items.DIAMOND), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> playerCuriosHandler, new SideConfigurator.RelativeFace[0]);
            this.invHandlers.add(playerCuriosHandler);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void clearRemoved() {
        super.clearRemoved();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getAerialInterfaces().add(this);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void setRemoved() {
        super.setRemoved();
        NeoForge.EVENT_BUS.unregister((Object)this);
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getAerialInterfaces().remove(this);
    }

    @SubscribeEvent
    public void onPlayerDimChanged(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!this.isRemoved() && this.isConnectedToPlayer && event.getEntity() == this.playerRef.get()) {
            this.validatePlayerNow = true;
        }
    }

    public void setPlayer(Player player) {
        if (player == this.playerRef.get()) {
            return;
        }
        this.invHandlers.forEach(PlayerInvHandler::invalidate);
        this.playerRef = new WeakReference<Player>(player);
        boolean wasConnected = this.isConnectedToPlayer;
        if (player == null) {
            this.isConnectedToPlayer = false;
            this.playerName = "";
        } else {
            this.isConnectedToPlayer = true;
            this.playerName = player.getGameProfile().getName();
            this.scanForChargeableItems(player);
        }
        if (wasConnected != this.isConnectedToPlayer) {
            this.needUpdateNeighbours = true;
            this.setChanged();
        }
    }

    public void setPlayerId(UUID uuid) {
        this.playerUUID = uuid;
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        if (this.playerName.isEmpty()) {
            this.gameProfileClient = null;
        } else {
            SkullBlockEntity.fetchGameProfile((String)this.playerName).thenAcceptAsync(optProfile -> {
                this.gameProfileClient = optProfile.orElse(null);
            });
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        boolean wasInserted = this.dispenserUpgradeInserted;
        boolean bl = this.dispenserUpgradeInserted = this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0;
        if (wasInserted != this.dispenserUpgradeInserted) {
            this.needUpdateNeighbours = true;
            this.invalidateCapabilities();
        }
    }

    @Override
    public void tickServer() {
        Level level;
        super.tickServer();
        if (this.needUpdateNeighbours) {
            this.needUpdateNeighbours = false;
            this.updateNeighbours();
        }
        if ((level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.validatePlayerNow || (this.getLevel().getGameTime() & 0xFL) == 0L) {
                ServerPlayer player2 = serverLevel.getServer().getPlayerList().getPlayer(this.playerUUID);
                this.setPlayer((Player)player2);
                this.operatingProblem = player2 != null && player2.getTags().contains(NO_AERIAL_INTERFACE) ? OperatingProblem.PLAYER_BARRED : (AerialInterfaceBlockEntity.isDimensionBlacklisted(serverLevel, player2) ? OperatingProblem.BAD_DIMENSION : OperatingProblem.OK);
                this.validatePlayerNow = false;
            }
        }
        this.getPlayer().ifPresent(player -> {
            if (this.aiCanOperate()) {
                this.addAir(-1);
                if ((this.nonNullLevel().getGameTime() & 0x3FL) == 0L) {
                    this.scanForChargeableItems((Player)player);
                }
                this.supplyEnergyToPlayer((Player)player);
                this.supplyAirToPlayer((Player)player);
            }
        });
        if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
            this.oldRedstoneStatus = this.rsController.shouldEmit();
            this.needUpdateNeighbours = true;
        }
    }

    private static boolean isDimensionBlacklisted(ServerLevel beLevel, ServerPlayer player) {
        return ((WildcardedRLMatcher)dimensionBlacklist.get()).test(beLevel.dimension().location()) || player != null && ((WildcardedRLMatcher)dimensionBlacklist.get()).test(player.level().dimension().location());
    }

    public static void clearDimensionBlacklist() {
        dimensionBlacklist.invalidate();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("xpType")) {
            ++this.curXPFluidIndex;
            List<Fluid> available = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (this.curXPFluidIndex >= available.size()) {
                this.curXPFluidIndex = -1;
            }
            this.curXpFluid = this.curXPFluidIndex >= 0 ? available.get(this.curXPFluidIndex) : Fluids.EMPTY;
            this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
            this.invalidateCapabilities();
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(tag, shiftHeld)) {
            this.needUpdateNeighbours = true;
        } else {
            try {
                this.feedMode = FeedMode.valueOf(tag);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setChanged();
    }

    private Optional<Player> getPlayer() {
        Player player = (Player)this.playerRef.get();
        return player != null && player.isAlive() ? Optional.of(player) : Optional.empty();
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.dispenserUpgradeInserted ? this.playerFoodHandler : this.itemHandlerSideConfigurator.getHandler(dir);
    }

    @Override
    public IFluidHandler getFluidHandler(@org.jetbrains.annotations.Nullable Direction dir) {
        return this.dispenserUpgradeInserted && this.curXpFluid != Fluids.EMPTY ? this.playerExperienceHandler : null;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@org.jetbrains.annotations.Nullable Direction dir) {
        return this.energyStorage;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.playerUUID = UUID.fromString(tag.getString("playerUUID"));
        this.feedMode = FeedMode.valueOf(tag.getString("feedMode"));
        this.curXpFluid = tag.contains("curXpFluid") ? (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)tag.getString("curXpFluid"))) : Fluids.EMPTY;
        this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        this.energyStorage.readFromNBT(tag);
        this.curXPFluidIndex = this.curXpFluid == Fluids.EMPTY ? -1 : XPFluidManager.getInstance().getAvailableLiquidXPs().indexOf(this.curXpFluid);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("playerUUID", this.playerUUID.toString());
        tag.putString("feedMode", this.feedMode.toString());
        tag.putString("curXpFluid", PneumaticCraftUtils.getRegistryName(this.curXpFluid).orElseThrow().toString());
        this.energyStorage.writeToNBT(tag);
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getComparatorValue() {
        return this.rsController.shouldEmit() ? 15 : 0;
    }

    private void scanForChargeableItems(Player player) {
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        this.chargeableSlots.clear();
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (!IOHelper.getEnergyStorageForItem(inv.getItem(i)).isPresent()) continue;
            this.chargeableSlots.add(i);
        }
    }

    private void supplyEnergyToPlayer(Player player) {
        if (this.energyStorage.getEnergyStored() > 0) {
            int slot;
            ItemStack stack;
            int energyLeft;
            Inventory inv = player.getInventory();
            IntListIterator intListIterator = this.chargeableSlots.iterator();
            while (intListIterator.hasNext() && (energyLeft = IOHelper.getEnergyStorageForItem(stack = inv.getItem(slot = ((Integer)intListIterator.next()).intValue())).map(receivingStorage -> {
                int stored = this.energyStorage.getEnergyStored();
                if (stored > 0) {
                    this.energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(stored, 1000), false), false);
                }
                return this.energyStorage.getEnergyStored();
            }).orElse(this.energyStorage.getEnergyStored()).intValue()) != 0) {
            }
            if (Curios.available && this.energyStorage.getEnergyStored() > 0) {
                CuriosUtils.chargeItems(player, this.energyStorage, 1000);
            }
        }
    }

    private void supplyAirToPlayer(Player player) {
        if (player.getAirSupply() <= 170) {
            int playerAir = 300 - player.getAirSupply();
            player.setAirSupply(300);
            this.addAir(-playerAir * 5);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundSource.PLAYERS, player.blockPosition(), 1.0f, 0.9f, false), (ServerPlayer)player);
        }
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new AerialInterfaceMenu(windowId, playerInventory, this.getBlockPos());
    }

    @Override
    public RedstoneController<AerialInterfaceBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private boolean aiCanOperate() {
        return this.operatingProblem == OperatingProblem.OK && this.getPressure() >= this.getMinWorkingPressure();
    }

    public static enum FeedMode implements ITranslatableEnum
    {
        FRUGAL("frugal", Items.COOKED_BEEF),
        GREEDY("greedy", Items.APPLE),
        SMART("smart", Items.GOLDEN_APPLE);

        private final String key;
        private final ItemStack stack;

        private FeedMode(String key, Item item) {
            this.key = key;
            this.stack = new ItemStack((ItemLike)item);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.info.aerialInterface.feedMode." + this.key;
        }

        public String getDescTranslationKey() {
            return this.getTranslationKey() + ".desc";
        }

        public ItemStack getIconStack() {
            return this.stack;
        }
    }

    public static enum OperatingProblem implements ITranslatableEnum
    {
        OK("ok"),
        BAD_DIMENSION("bad_dimension"),
        PLAYER_BARRED("player_barred");

        private final String name;

        private OperatingProblem(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.info.aerialInterface.problem." + this.name;
        }
    }

    private class PlayerExperienceHandler
    implements IFluidHandler {
        private PlayerExperienceHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (AerialInterfaceBlockEntity.this.curXpFluid != Fluids.EMPTY) {
                return AerialInterfaceBlockEntity.this.getPlayer().map(p -> new FluidStack(AerialInterfaceBlockEntity.this.curXpFluid, EnchantmentUtils.getPlayerXP(p) * AerialInterfaceBlockEntity.this.curXpRatio)).orElse(FluidStack.EMPTY);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return AerialInterfaceBlockEntity.this.curXpFluid != Fluids.EMPTY && stack.getFluid() == AerialInterfaceBlockEntity.this.curXpFluid;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (AerialInterfaceBlockEntity.this.curXpRatio != 0 && this.canFill(resource.getFluid())) {
                    int pointsAdded = resource.getAmount() / AerialInterfaceBlockEntity.this.curXpRatio;
                    if (doFill.execute()) {
                        player.giveExperiencePoints(pointsAdded);
                    }
                    return pointsAdded * AerialInterfaceBlockEntity.this.curXpRatio;
                }
                return 0;
            }).orElse(0);
        }

        private boolean canFill(Fluid fluid) {
            return AerialInterfaceBlockEntity.this.dispenserUpgradeInserted && fluid != Fluids.EMPTY && fluid == AerialInterfaceBlockEntity.this.curXpFluid && AerialInterfaceBlockEntity.this.curXpRatio != 0 && AerialInterfaceBlockEntity.this.aiCanOperate();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (AerialInterfaceBlockEntity.this.curXpRatio != 0 && AerialInterfaceBlockEntity.this.dispenserUpgradeInserted && AerialInterfaceBlockEntity.this.aiCanOperate()) {
                    int pointsDrained = Math.min(EnchantmentUtils.getPlayerXP(player), resource.getAmount() / AerialInterfaceBlockEntity.this.curXpRatio);
                    if (doDrain.execute()) {
                        EnchantmentUtils.addPlayerXP(player, -pointsDrained);
                    }
                    return new FluidStack(resource.getFluid(), pointsDrained * AerialInterfaceBlockEntity.this.curXpRatio);
                }
                return FluidStack.EMPTY;
            }).orElse(FluidStack.EMPTY);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (AerialInterfaceBlockEntity.this.curXpFluid == Fluids.EMPTY) {
                return FluidStack.EMPTY;
            }
            return this.drain(new FluidStack(AerialInterfaceBlockEntity.this.curXpFluid, maxDrain), doDrain);
        }
    }

    private class PlayerFoodHandler
    implements IItemHandler {
        private PlayerFoodHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!AerialInterfaceBlockEntity.this.aiCanOperate()) {
                return stack;
            }
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (this.getFoodValue(stack) <= 0 || !this.okToFeed(stack, (Player)player)) {
                    return stack;
                }
                if (simulate) {
                    return ItemStack.EMPTY;
                }
                int startValue = stack.getCount();
                ItemStack remainingItem = stack;
                ItemStack copy = stack.copy();
                while (stack.getCount() > 0) {
                    remainingItem = stack.finishUsingItem(player.level(), (LivingEntity)player);
                    if (!((remainingItem = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)stack, (int)0, (ItemStack)remainingItem)).getCount() <= 0 || remainingItem == stack && remainingItem.getCount() == startValue || player.getInventory().add(remainingItem) || remainingItem.getCount() <= 0)) {
                        player.drop(remainingItem, false);
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.gui.aerial_interface.fedItem", (Object[])new Object[]{copy.getHoverName()}), true);
                    if (stack.getCount() != startValue) continue;
                }
                return remainingItem.getCount() > 0 ? remainingItem : ItemStack.EMPTY;
            }).orElse(stack);
        }

        private boolean okToFeed(@Nonnull ItemStack stack, Player player) {
            int foodValue = this.getFoodValue(stack);
            int curFoodLevel = player.getFoodData().getFoodLevel();
            FeedMode effectiveFeedMode = AerialInterfaceBlockEntity.this.feedMode == FeedMode.SMART ? (player.getHealth() < player.getMaxHealth() ? FeedMode.GREEDY : FeedMode.FRUGAL) : AerialInterfaceBlockEntity.this.feedMode;
            return switch (effectiveFeedMode.ordinal()) {
                case 0 -> {
                    if (20 - curFoodLevel >= foodValue * stack.getCount()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (20 - curFoodLevel >= foodValue * (stack.getCount() - 1) + 1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getFoodValue(stack) > 0;
        }

        private int getFoodValue(ItemStack stack) {
            return stack.has(DataComponents.FOOD) ? ((FoodProperties)stack.get(DataComponents.FOOD)).nutrition() : 0;
        }
    }

    private class PlayerMainInvHandler
    extends PlayerInvHandler {
        private PlayerMainInvHandler(AerialInterfaceBlockEntity aerialInterfaceBlockEntity) {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerMainInvWrapper::new);
        }
    }

    private class PlayerArmorInvHandler
    extends PlayerInvHandler {
        private PlayerArmorInvHandler(AerialInterfaceBlockEntity aerialInterfaceBlockEntity) {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerArmorInvWrapper::new);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            return EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) ? ItemStack.EMPTY : super.extractItem(slot, amount, simulate);
        }
    }

    private class PlayerOffhandInvHandler
    extends PlayerInvHandler {
        private PlayerOffhandInvHandler(AerialInterfaceBlockEntity aerialInterfaceBlockEntity) {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerOffhandInvWrapper::new);
        }
    }

    private class PlayerEnderInvHandler
    extends PlayerInvHandler {
        private PlayerEnderInvHandler(AerialInterfaceBlockEntity aerialInterfaceBlockEntity) {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, p -> new InvWrapper((Container)p.player.getEnderChestInventory()));
        }
    }

    private class PlayerCuriosHandler
    extends PlayerInvHandler {
        private PlayerCuriosHandler(AerialInterfaceBlockEntity aerialInterfaceBlockEntity) {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, p -> CuriosUtils.makeCombinedInvWrapper(p.player));
        }
    }

    private abstract class PlayerInvHandler
    implements IItemHandler {
        IItemHandler cached = null;

        private PlayerInvHandler() {
        }

        void invalidate() {
            this.cached = null;
        }

        IItemHandler getCachedHandler(Player p, Function<Inventory, IItemHandler> f) {
            if (this.cached == null) {
                this.cached = f.apply(p.getInventory());
            }
            return this.cached;
        }

        protected abstract IItemHandler getInvWrapper(@Nonnull Player var1);

        public int getSlots() {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.aiCanOperate()).map(p -> this.getInvWrapper((Player)p).getSlots()).orElse(0);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.aiCanOperate()).map(p -> this.getInvWrapper((Player)p).getStackInSlot(slot)).orElse(ItemStack.EMPTY);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.aiCanOperate()).map(p -> this.getInvWrapper((Player)p).insertItem(slot, stack, simulate)).orElse(stack);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.aiCanOperate()).map(p -> this.getInvWrapper((Player)p).extractItem(slot, amount, simulate)).orElse(ItemStack.EMPTY);
        }

        public int getSlotLimit(int slot) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.aiCanOperate()).map(p -> this.getInvWrapper((Player)p).getSlotLimit(slot)).orElse(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AerialInterfaceBlockEntity.this.aiCanOperate();
        }
    }
}

