/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.tube;

import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TubeJunctionBlockEntity
extends AbstractAirHandlingBlockEntity {
    private final IAirHandlerMachine tube2Handler = new MachineAirHandler(PressureTier.TIER_TWO, 4000);

    public TubeJunctionBlockEntity(BlockPos pPos, BlockState pState) {
        super(ModBlockEntityTypes.TUBE_JUNCTION.get(), pPos, pState, PressureTier.TIER_TWO, 4000, 0);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    @Nullable
    public IAirHandlerMachine getAirHandler(Direction dir) {
        Direction.Axis axis;
        if (dir != null && ((axis = (Direction.Axis)this.getBlockState().getValue((Property)BlockStateProperties.AXIS)) == Direction.Axis.X && dir.getAxis() == Direction.Axis.Y || axis == Direction.Axis.Y && dir.getAxis() == Direction.Axis.Z || axis == Direction.Axis.Z && dir.getAxis() == Direction.Axis.X)) {
            return this.tube2Handler;
        }
        return super.getAirHandler(dir);
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.getAxis() != this.getBlockState().getValue((Property)BlockStateProperties.AXIS);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("tube2", this.tube2Handler.serializeNBT());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tube2Handler.deserializeNBT(tag.getCompound("tube2"));
    }
}

