/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import me.desht.pneumaticcraft.common.block.entity.processing.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AssemblyDrillBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    @DescSynced
    private boolean isDrillOn;
    @DescSynced
    @LazySynced
    private float drillSpeed;
    public float drillRotation;
    public float oldDrillRotation;
    private int drillStep;

    public AssemblyDrillBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ASSEMBLY_DRILL.get(), pos, state);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.oldDrillRotation = this.drillRotation;
        this.drillSpeed = this.isDrillOn ? Math.min(this.drillSpeed + 1.0f * this.speed, 100.0f) : Math.max(this.drillSpeed - 1.0f * this.speed, 0.0f);
        this.drillRotation += this.drillSpeed;
        while (this.drillRotation >= 360.0f) {
            this.drillRotation -= 360.0f;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.drillStep > 0) {
            AbstractAssemblyRobotBlockEntity.TargetDirections platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.drillStep = 1;
            }
            switch (this.drillStep) {
                case 1: 
                case 6: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection);
                    break;
                }
                case 3: {
                    this.isDrillOn = true;
                    break;
                }
                case 4: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection);
                    break;
                }
                case 5: {
                    AssemblyPlatformBlockEntity platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection);
                    this.isDrillOn = false;
                    BlockEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof AssemblyPlatformBlockEntity) || (output = this.getDrilledOutputForItem((platform = (AssemblyPlatformBlockEntity)te).getHeldStack())).isEmpty()) break;
                    platform.setHeldStack(output);
                }
            }
            if (this.isDoneInternal()) {
                ++this.drillStep;
                if (this.drillStep > 6) {
                    this.drillStep = 0;
                }
            }
        }
    }

    public void goDrilling() {
        if (this.drillStep == 0) {
            this.drillStep = 1;
            this.setChanged();
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("drill", this.isDrillOn);
        tag.putFloat("drillSpeed", this.drillSpeed);
        tag.putInt("drillStep", this.drillStep);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.isDrillOn = tag.getBoolean("drill");
        this.drillSpeed = tag.getFloat("drillSpeed");
        this.drillStep = tag.getInt("drillStep");
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public boolean isIdle() {
        return this.drillStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.DRILL;
    }

    private boolean isDoneInternal() {
        if (super.isDoneMoving()) {
            return this.isDrillOn ? this.drillSpeed > 99.0f : PneumaticCraftUtils.epsilonEquals(this.drillSpeed, 0.0f);
        }
        return false;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    private ItemStack getDrilledOutputForItem(ItemStack input) {
        return ModRecipeTypes.ASSEMBLY_DRILL.get().stream(this.level).map(RecipeHolder::value).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isDrillOn = false;
        this.drillStep = 6;
        return false;
    }
}

