/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.semiblock.LogisticsLiquidFilterScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class AmadronAddTradeScreen
extends AbstractPneumaticCraftContainerScreen<AmadronAddTradeMenu, AbstractPneumaticCraftBlockEntity> {
    private ItemSearcherScreen searchGui;
    private InventorySearcherScreen invSearchGui;
    private InventorySearcherScreen gpsSearchGui;
    private LogisticsLiquidFilterScreen fluidGui;
    private int settingSlot;
    private final WidgetFluidStack[] fluidFilters = new WidgetFluidStack[2];
    private final WidgetTextFieldNumber[] amountFields = new WidgetTextFieldNumber[2];
    private final BlockPos[] positions = new BlockPos[2];
    private Button addButton;
    private boolean openingSubGUI = false;

    public AmadronAddTradeScreen(AmadronAddTradeMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageWidth = 183;
        this.imageHeight = 202;
    }

    @Override
    public void init() {
        super.init();
        if (this.searchGui != null) {
            this.setStack(this.settingSlot, this.searchGui.getSearchStack());
        } else if (this.invSearchGui != null) {
            this.setStack(this.settingSlot, this.invSearchGui.getSearchStack());
        } else if (this.fluidGui != null) {
            this.setFluid(this.settingSlot, this.fluidGui.getFilter());
            this.amountFields[this.settingSlot].setRange(1, Integer.MAX_VALUE).setValue(1000);
        } else if (this.gpsSearchGui != null) {
            GPSToolItem.getGPSLocation(this.gpsSearchGui.getSearchStack()).ifPresent(pos -> {
                this.positions[this.settingSlot] = pos;
            });
        }
        this.openingSubGUI = false;
        this.searchGui = null;
        this.fluidGui = null;
        this.invSearchGui = null;
        this.gpsSearchGui = null;
        this.initSide(0);
        this.initSide(1);
        this.setFocused((GuiEventListener)this.amountFields[0]);
        this.addButton = new WidgetButtonExtended(this.leftPos + 50, this.topPos + 171, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.addTrade", new Object[0]), b -> this.addTrade());
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.addJeiFilterInfoTab();
    }

    public void setStack(int slot, ItemStack stack) {
        this.fluidFilters[slot].setFluid(Fluids.EMPTY);
        ((AmadronAddTradeMenu)this.menu).setStack(slot, stack);
    }

    public void setFluid(int slot, Fluid stack) {
        ((AmadronAddTradeMenu)this.menu).setStack(slot, ItemStack.EMPTY);
        this.fluidFilters[slot].setFluid(stack);
    }

    private void initSide(int slot) {
        int xOffset = slot == 0 ? 0 : 89;
        String s = slot == 0 ? "selling" : "buying";
        this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 48 + xOffset, this.topPos + 7, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.addTrade." + s, new Object[0]), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 4 + xOffset, this.topPos + 20, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchItem", new Object[0]), b -> this.openItemSearchGui(slot)));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 4 + xOffset, this.topPos + 42, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchInventory", new Object[0]), b -> this.openInventorySearchGui(slot)));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 4 + xOffset, this.topPos + 64, 85, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchFluid", new Object[0]), b -> this.openFluidSearchGui(slot)));
        Fluid prev = this.fluidFilters[slot] != null ? this.fluidFilters[slot].getFluid() : Fluids.EMPTY;
        this.fluidFilters[slot] = new WidgetFluidStack(this.leftPos + 37 + xOffset, this.topPos + 90, prev, null);
        this.addRenderableWidget((GuiEventListener)this.fluidFilters[slot]);
        String tip = slot == 0 ? "pneumaticcraft.gui.amadron.button.selectSellingBlock.tooltip" : "pneumaticcraft.gui.amadron.button.selectPaymentBlock.tooltip";
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 10 + xOffset, this.topPos + 115, 20, 20, "", b -> this.openGPSGui(slot)).setRenderStacks(new ItemStack((ItemLike)ModItems.GPS_TOOL.get())).setTooltipKey(tip));
        int coarse = this.fluidFilters[slot].getFluid() == Fluids.EMPTY ? 10 : 1000;
        int max = this.fluidFilters[slot].getFluid() == Fluids.EMPTY ? 64 : Integer.MAX_VALUE;
        Objects.requireNonNull(this.font);
        this.amountFields[slot] = new WidgetTextFieldNumber(this.font, this.leftPos + 22 + xOffset, this.topPos + 144, 40, 9 + 3).setRange(1, max).setValue(this.amountFields[slot] != null ? this.amountFields[slot].getIntValue() : 1).setAdjustments(1.0, coarse);
        this.addRenderableWidget((GuiEventListener)this.amountFields[slot]);
        this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 65 + xOffset, this.topPos + 145, (Component)Component.literal((String)(this.fluidFilters[slot].getFluid() != Fluids.EMPTY ? "mB" : "")), -1));
        GlobalPos p = this.getPosition(slot);
        if (p != null && GlobalPosHelper.isSameWorld(p, ClientUtils.getClientLevel())) {
            BlockState state = ClientUtils.getClientLevel().getBlockState(p.pos());
            Component name = new ItemStack((ItemLike)state.getBlock().asItem()).getHoverName();
            ((WidgetLabel)this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 32 + xOffset, this.topPos + 118, name, -1))).setScale(0.5f);
            ((WidgetLabel)this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 32 + xOffset, this.topPos + 124, (Component)Component.literal((String)(" @ " + this.posToString(p.pos()))), -1))).setScale(0.5f);
        }
        if (this.positions[slot] == null) {
            ((WidgetLabel)this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 32 + xOffset, this.topPos + 130, (Component)Component.literal((String)"[Default]"), -4144960))).setScale(0.5f);
        }
    }

    private String posToString(BlockPos pos) {
        return pos == null ? "[Default]" : PneumaticCraftUtils.posToString(pos);
    }

    @Override
    public void removed() {
        if (!this.openingSubGUI) {
            NetworkHandler.sendToServer(new PacketGuiButton("showAmadron"));
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener guiEventListener;
        if (keyCode == 256) {
            this.removed();
            return true;
        }
        if (keyCode == 258) {
            WidgetTextFieldNumber amountIn = this.amountFields[0];
            WidgetTextFieldNumber amountOut = this.amountFields[1];
            if (amountIn.isFocused()) {
                amountIn.moveCursorTo(amountIn.getCursorPosition(), true);
                amountIn.setFocused(false);
                this.setFocused((GuiEventListener)amountOut);
                amountOut.moveCursorTo(0, false);
                amountOut.setHighlightPos(amountOut.getValue().length());
            } else if (amountOut.isFocused()) {
                amountOut.moveCursorTo(amountOut.getCursorPosition(), true);
                amountOut.setFocused(false);
                this.setFocused((GuiEventListener)amountIn);
                amountIn.moveCursorTo(0, false);
                amountIn.setHighlightPos(amountIn.getValue().length());
            }
        }
        if ((guiEventListener = this.getFocused()) instanceof WidgetTextField) {
            WidgetTextField tf = (WidgetTextField)guiEventListener;
            return tf.keyPressed(keyCode, scanCode, modifiers) || tf.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected OptionalInt getBackgroundTint() {
        return OptionalInt.of(-16347604);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON_ADD_TRADE;
    }

    private void openItemSearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui(ModMenuTypes.ITEM_SEARCHER.get(), (Component)Component.translatable((String)"pneumaticcraft.gui.amadron.addTrade.itemSearch"));
        Screen screen = this.minecraft.screen;
        if (screen instanceof ItemSearcherScreen) {
            ItemSearcherScreen scr = (ItemSearcherScreen)screen;
            this.settingSlot = slot;
            this.searchGui = scr;
            this.searchGui.setSearchStack(((AmadronAddTradeMenu)this.menu).getStack(slot));
        }
    }

    private void openInventorySearchGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.translatable((String)"pneumaticcraft.gui.amadron.addTrade.invSearch"));
        Screen screen = this.minecraft.screen;
        if (screen instanceof InventorySearcherScreen) {
            InventorySearcherScreen scr = (InventorySearcherScreen)screen;
            this.settingSlot = slot;
            this.invSearchGui = scr;
            this.invSearchGui.setSearchStack(((AmadronAddTradeMenu)this.menu).getStack(slot));
        }
    }

    private void openFluidSearchGui(int slot) {
        this.openingSubGUI = true;
        this.settingSlot = slot;
        this.fluidGui = new LogisticsLiquidFilterScreen((Screen)this);
        this.fluidGui.setFilter(this.fluidFilters[slot].getFluid());
        this.minecraft.setScreen((Screen)this.fluidGui);
    }

    private void openGPSGui(int slot) {
        this.openingSubGUI = true;
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.translatable((String)"pneumaticcraft.gui.amadron.addTrade.gpsSearch"));
        Screen screen = this.minecraft.screen;
        if (screen instanceof InventorySearcherScreen) {
            InventorySearcherScreen scr;
            this.gpsSearchGui = scr = (InventorySearcherScreen)screen;
            this.gpsSearchGui.setStackPredicate(itemStack -> itemStack.getItem() instanceof IPositionProvider);
            this.settingSlot = slot;
            ItemStack gps = new ItemStack((ItemLike)ModItems.GPS_TOOL.get());
            GlobalPos gPos = this.getPosition(slot);
            if (gPos != null) {
                GPSToolItem.setGPSLocation(ClientUtils.getClientPlayer().getUUID(), gps, gPos.pos());
            }
            this.gpsSearchGui.setSearchStack(GPSToolItem.getGPSLocation(gps).isPresent() ? gps : ItemStack.EMPTY);
        }
    }

    private void addTrade() {
        AmadronTradeResource[] resources = new AmadronTradeResource[2];
        for (int slot = 0; slot < resources.length; ++slot) {
            resources[slot] = !((AmadronAddTradeMenu)this.menu).getStack(slot).isEmpty() ? AmadronTradeResource.of(((AmadronAddTradeMenu)this.menu).getStack(slot).copyWithCount(this.amountFields[slot].getIntValue())) : AmadronTradeResource.of(new FluidStack(this.fluidFilters[slot].getFluid(), this.amountFields[slot].getIntValue()));
        }
        String id = ClientUtils.getClientPlayer().getName().getString().toLowerCase() + "_" + System.currentTimeMillis() / 1000L;
        AmadronPlayerOffer trade = new AmadronPlayerOffer(PneumaticRegistry.RL(id), resources[1], resources[0], ClientUtils.getClientPlayer()).setProvidingPosition(this.getPosition(0)).setReturningPosition(this.getPosition(1));
        NetworkHandler.sendToServer(new PacketAmadronTradeAddCustom(trade));
    }

    private GlobalPos getPosition(int slot) {
        if (this.positions[slot] != null) {
            return GlobalPosHelper.makeGlobalPos(ClientUtils.getClientLevel(), this.positions[slot]);
        }
        if (!((AmadronAddTradeMenu)this.menu).getStack(slot).isEmpty()) {
            return AmadronTabletItem.getItemProvidingLocation(ClientUtils.getClientPlayer().getMainHandItem());
        }
        if (this.fluidFilters[slot].getFluid() != Fluids.EMPTY) {
            return AmadronTabletItem.getFluidProvidingLocation(ClientUtils.getClientPlayer().getMainHandItem());
        }
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        GlobalPos inPos = this.getPosition(0);
        GlobalPos outPos = this.getPosition(1);
        this.addButton.active = !(this.amountFields[0].getIntValue() <= 0 || this.amountFields[1].getIntValue() <= 0 || this.fluidFilters[0].getFluid() == Fluids.EMPTY && ((AmadronAddTradeMenu)this.menu).getInputStack().isEmpty() || this.fluidFilters[1].getFluid() == Fluids.EMPTY && ((AmadronAddTradeMenu)this.menu).getOutputStack().isEmpty() || inPos == null || outPos == null);
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        if (this.getPosition(0) == null || this.getPosition(1) == null) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.addTrade.problems.noSellingOrPayingBlock", new Object[0]));
        }
        super.addProblems(curInfo);
    }
}

