/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import java.util.Objects;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix4f;

public record MicromissileClientTooltip(MicromissilesItem.Tooltip component) implements ClientTooltipComponent
{
    public void renderText(Font pFont, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
        if (this.component.stack().has(ModDataComponents.MICROMISSILE_SETTINGS)) {
            int col = ChatFormatting.GRAY.getColor();
            pFont.drawInBatch((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0]), (float)pX, (float)(pY += 3), col, false, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            MutableComponent mutableComponent = PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0]);
            float f = pX;
            Objects.requireNonNull(pFont);
            pFont.drawInBatch((Component)mutableComponent, f, (float)(pY + 9 + 1), col, false, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            MutableComponent mutableComponent2 = PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0]);
            float f2 = pX;
            Objects.requireNonNull(pFont);
            pFont.drawInBatch((Component)mutableComponent2, f2, (float)(pY + 9 * 2 + 2), col, false, pMatrix4f, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(Font pFont, int pMouseX, int pMouseY, GuiGraphics graphics) {
        if (this.component.stack().has(ModDataComponents.MICROMISSILE_SETTINGS)) {
            MicromissilesItem.Settings settings = (MicromissilesItem.Settings)this.component.stack().get(ModDataComponents.MICROMISSILE_SETTINGS);
            pMouseY += 3;
            Objects.requireNonNull(pFont);
            int vSpace = 9 + 1;
            int width = pFont.width((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0]));
            width = Math.max(width, pFont.width((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0])));
            width = Math.max(width, pFont.width((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0])));
            int barX = width + 5;
            int barY = 0;
            int barW = this.getWidth(pFont) - width - 10;
            graphics.pose().pushPose();
            graphics.pose().translate((float)pMouseX, (float)pMouseY, 0.0f);
            MicromissileClientTooltip.drawLine(graphics, barX, barY, barW, settings.topSpeed());
            MicromissileClientTooltip.drawLine(graphics, barX, barY + vSpace, barW, settings.turnSpeed());
            MicromissileClientTooltip.drawLine(graphics, barX, barY + 2 * vSpace, barW, settings.damage());
            graphics.pose().popPose();
        }
    }

    public int getHeight() {
        return this.component.stack().has(ModDataComponents.MICROMISSILE_SETTINGS) ? 33 : 0;
    }

    public int getWidth(Font pFont) {
        return 150;
    }

    private static void drawLine(GuiGraphics graphics, int x, int y, int totalWidth, float amount) {
        int w1 = (int)((float)totalWidth * amount);
        graphics.fill(x, y, x + totalWidth, y + 9, -15198184);
        graphics.fill(x, y + 1, x + w1, y + 8, -16728064);
        for (int i = x + 3; i < x + w1; i += 4) {
            graphics.fill(i, y + 1, i + 1, y + 8, -16752640);
        }
    }
}

