/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.remote;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.misc.IGlobalVariableHelper;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.api.remote.BaseSettings;
import me.desht.pneumaticcraft.api.remote.IRemoteVariableWidget;
import me.desht.pneumaticcraft.api.remote.RemoteWidgetType;
import me.desht.pneumaticcraft.api.remote.WidgetSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

public interface IRemoteWidget {
    public static final int TRAY_WIDGET_X = 200;
    public static final Codec<IRemoteWidget> CODEC = PNCRegistries.REMOTE_WIDGETS_REGISTRY.byNameCodec().dispatch(IRemoteWidget::getType, RemoteWidgetType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IRemoteWidget> STREAM_CODEC = ByteBufCodecs.registry(PNCRegistries.REMOTE_WIDGETS_KEY).dispatch(IRemoteWidget::getType, RemoteWidgetType::streamCodec);

    public BaseSettings baseSettings();

    public WidgetSettings widgetSettings();

    @ApiStatus.NonExtendable
    default public IRemoteWidget copy() {
        return this.copyToPos(this.widgetSettings().x(), this.widgetSettings().y());
    }

    public IRemoteWidget copyToPos(int var1, int var2);

    default public boolean hasConfigurableText() {
        return true;
    }

    public RemoteWidgetType<? extends IRemoteWidget> getType();

    default public String getTranslationKey() {
        return IRemoteWidget.getTranslationKey(this.getType());
    }

    public static String getTranslationKey(RemoteWidgetType<?> type) {
        String id = PNCRegistries.REMOTE_WIDGETS_REGISTRY.getResourceKey(type).map(key -> key.location().toLanguageKey()).orElse("unknown");
        return "pneumaticcraft.gui.remote.tray." + id + ".name";
    }

    public static String getTooltipTranslationKey(RemoteWidgetType<?> type) {
        String id = PNCRegistries.REMOTE_WIDGETS_REGISTRY.getResourceKey(type).map(key -> key.location().toLanguageKey()).orElse("unknown");
        return "pneumaticcraft.gui.remote.tray." + id + ".tooltip";
    }

    default public void discoverVariables(Set<String> variables, UUID playerId) {
        IRemoteVariableWidget v;
        IRemoteWidget iRemoteWidget;
        if (!this.baseSettings().enableVariable().isEmpty()) {
            variables.add(this.baseSettings().enableVariable());
        }
        if ((iRemoteWidget = this) instanceof IRemoteVariableWidget && !(v = (IRemoteVariableWidget)iRemoteWidget).varName().isEmpty()) {
            variables.add(v.varName());
        }
        IGlobalVariableHelper helper = PneumaticRegistry.getInstance().getMiscHelpers().getGlobalVariableHelper();
        this.widgetSettings().title().visit(string -> {
            variables.addAll(helper.getRelevantVariables(string, playerId));
            return Optional.empty();
        });
    }

    default public boolean isEnabled(Player player) {
        if (this.baseSettings().enableVariable().isEmpty()) {
            return true;
        }
        BlockPos pos = PneumaticRegistry.getInstance().getMiscHelpers().getGlobalVariableHelper().getPos(player.getUUID(), this.baseSettings().enableVariable(), BlockPos.ZERO);
        return pos.equals((Object)this.baseSettings().enablingValue());
    }
}

