/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.base.Suppliers;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public record FluidContainerIngredient(Either<FluidStack, TagWithAmount> either) implements ICustomIngredient
{
    public static final MapCodec<FluidContainerIngredient> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.either((Codec)FluidStack.CODEC, TagWithAmount.CODEC).fieldOf("fluid").forGetter(FluidContainerIngredient::either)).apply((Applicative)builder, FluidContainerIngredient::new));
    public static final Codec<FluidContainerIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.either((Codec)FluidStack.CODEC, TagWithAmount.CODEC).fieldOf("fluid").forGetter(FluidContainerIngredient::either)).apply((Applicative)builder, FluidContainerIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidContainerIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)FluidStack.STREAM_CODEC, TagWithAmount.STREAM_CODEC), FluidContainerIngredient::either, FluidContainerIngredient::new);
    private static final Supplier<List<Block>> TANK_BLOCKS = Suppliers.memoize(() -> Stream.of(PneumaticRegistry.RL("small_tank"), PneumaticRegistry.RL("medium_tank"), PneumaticRegistry.RL("large_tank"), PneumaticRegistry.RL("huge_tank")).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).toList());

    public static FluidContainerIngredient of(Fluid fluid, int amount) {
        return new FluidContainerIngredient((Either<FluidStack, TagWithAmount>)Either.left((Object)new FluidStack(fluid, amount)));
    }

    public static FluidContainerIngredient of(TagKey<Fluid> tag, int amount) {
        return new FluidContainerIngredient((Either<FluidStack, TagWithAmount>)Either.right((Object)new TagWithAmount(tag, amount)));
    }

    public boolean test(ItemStack stack) {
        if (!stack.hasCraftingRemainingItem()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return false;
        }
        return (Boolean)this.either.map(fluidStack -> handler.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE).getAmount() >= fluidStack.getAmount(), tagWithAmount -> {
            FluidStack contained = handler.drain(tagWithAmount.amount, IFluidHandler.FluidAction.SIMULATE);
            return contained.getFluid().is(tagWithAmount.tag) && contained.getAmount() == tagWithAmount.amount;
        });
    }

    public Stream<ItemStack> getItems() {
        int amount = (Integer)this.either.map(FluidStack::getAmount, TagWithAmount::amount);
        List fluidStacks = (List)this.either.map(List::of, tagWithAmount -> StreamSupport.stream(BuiltInRegistries.FLUID.getTagOrEmpty(tagWithAmount.tag).spliterator(), false).map(holder -> new FluidStack((Fluid)holder.value(), amount)).toList());
        Stream buckets = amount == 1000 ? fluidStacks.stream().map(FluidUtil::getFilledBucket) : Stream.empty();
        IItemRegistry reg = PneumaticRegistry.getInstance().getItemRegistry();
        Stream tanks = fluidStacks.stream().flatMap(fluidStack -> TANK_BLOCKS.get().stream().map(b -> reg.createFluidContainingItem((ItemLike)b, (FluidStack)fluidStack)));
        return Streams.concat((Stream[])new Stream[]{buckets, tanks});
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return PneumaticRegistry.getInstance().getCustomIngredientTypes().fluidContainerType().get();
    }

    public int amount() {
        return (Integer)this.either.map(FluidStack::getAmount, TagWithAmount::amount);
    }

    public record TagWithAmount(TagKey<Fluid> tag, int amount) {
        public static final Codec<TagWithAmount> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(TagWithAmount::tag), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(TagWithAmount::amount)).apply((Applicative)builder, TagWithAmount::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TagWithAmount> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.map(rl -> TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)rl), TagKey::location), TagWithAmount::tag, (StreamCodec)ByteBufCodecs.INT, TagWithAmount::amount, TagWithAmount::new);
    }
}

