/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.event;

import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.init.ModEntities;
import cy.jdkdigital.everythingcopper.init.ModItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="everythingcopper")
public class EventHandler {
    @SubscribeEvent
    public static void placeCarvedPumpkin(BlockEvent.EntityPlaceEvent event) {
        if (event.getPlacedBlock().getBlock().equals(Blocks.CARVED_PUMPKIN) || event.getPlacedBlock().getBlock().equals(Blocks.JACK_O_LANTERN)) {
            LevelAccessor level = event.getLevel();
            BlockPattern copperGolemPattern = CopperGolem.getOrCreateCopperGolemFull();
            BlockPattern.BlockPatternMatch blockPatternMatch = copperGolemPattern.find((LevelReader)event.getLevel(), event.getPos());
            if (blockPatternMatch != null) {
                int waxed = 0;
                for (int j = 0; j < copperGolemPattern.getWidth(); ++j) {
                    for (int k = 0; k < copperGolemPattern.getHeight(); ++k) {
                        BlockInWorld block = blockPatternMatch.getBlock(j, k, 0);
                        if (BuiltInRegistries.BLOCK.getKey((Object)block.getState().getBlock()).getPath().contains("waxed")) {
                            ++waxed;
                        }
                        level.setBlock(block.getPos(), Blocks.AIR.defaultBlockState(), 2);
                        level.levelEvent(2001, block.getPos(), Block.getId((BlockState)block.getState()));
                    }
                }
                BlockPos blockpos = blockPatternMatch.getBlock(1, 2, 0).getPos();
                CopperGolem copperGolem = (CopperGolem)((EntityType)ModEntities.COPPER_GOLEM.get()).create((Level)level);
                copperGolem.setPlayerCreated(true);
                copperGolem.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.05, (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity((Entity)copperGolem);
                copperGolem.setWaxed(waxed == 4);
                for (ServerPlayer serverplayer1 : level.getEntitiesOfClass(ServerPlayer.class, copperGolem.getBoundingBox().inflate(5.0))) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer1, (Entity)copperGolem);
                }
                for (int i = 0; i < copperGolemPattern.getWidth(); ++i) {
                    for (int j = 0; j < copperGolemPattern.getHeight(); ++j) {
                        BlockInWorld block = blockPatternMatch.getBlock(i, j, 0);
                        level.blockUpdated(block.getPos(), Blocks.AIR);
                    }
                }
            }
        }
    }

    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.COPPER_GOLEM.get(), IronGolem.createAttributes().build());
    }

    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.COMBAT)) {
            event.accept((ItemLike)ModItems.COPPER_SWORD.get());
            event.accept((ItemLike)ModItems.COPPER_HELMET.get());
            event.accept((ItemLike)ModItems.COPPER_CHESTPLATE.get());
            event.accept((ItemLike)ModItems.COPPER_LEGGINGS.get());
            event.accept((ItemLike)ModItems.COPPER_BOOTS.get());
            event.accept((ItemLike)ModItems.COPPER_HORSE_ARMOR.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.accept((ItemLike)ModItems.COPPER_HOE.get());
            event.accept((ItemLike)ModItems.COPPER_AXE.get());
            event.accept((ItemLike)ModItems.COPPER_PICKAXE.get());
            event.accept((ItemLike)ModItems.COPPER_SHOVEL.get());
            event.accept((ItemLike)ModItems.COPPER_SHEARS.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.INGREDIENTS)) {
            event.accept((ItemLike)ModItems.COPPER_NUGGET.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            event.accept((ItemLike)ModBlocks.COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_PRESSURE_PLATE.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_BARS.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_CHAIN.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_BUTTON.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.REDSTONE_BLOCKS)) {
            event.accept((ItemLike)ModBlocks.COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_HOPPER.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_RAIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_RAIL.get());
        }
        if (event.getTabKey().equals(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
            event.accept((ItemLike)ModBlocks.WEATHERING_STATION.get());
            event.accept((ItemLike)ModBlocks.COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.CHIPPED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.CHIPPED_EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.CHIPPED_WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.CHIPPED_OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.DAMAGED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.DAMAGED_EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.DAMAGED_WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.DAMAGED_OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.EXPOSED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.WEATHERED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.OXIDIZED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_SOUL_LANTERN.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_CHIPPED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_CHIPPED_EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_CHIPPED_WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_CHIPPED_OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_DAMAGED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_DAMAGED_EXPOSED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_DAMAGED_WEATHERED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_DAMAGED_OXIDIZED_COPPER_ANVIL.get());
            event.accept((ItemLike)ModBlocks.WAXED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.WAXED_EXPOSED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.WAXED_WEATHERED_COPPER_LADDER.get());
            event.accept((ItemLike)ModBlocks.WAXED_OXIDIZED_COPPER_LADDER.get());
        }
    }
}

