/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartChest;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartCommandBlock;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartFurnace;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartHopper;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartSpawner;
import cy.jdkdigital.everythingcopper.common.entity.CopperMinecartTNT;
import cy.jdkdigital.everythingcopper.common.entity.IWeatheringEntity;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;

public class CopperMinecart
extends Minecart
implements IWeatheringEntity {
    public CopperMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public CopperMinecart(Level level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Override
    public SynchedEntityData getSyncData() {
        return super.getEntityData();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.name());
        pBuilder.define(DATA_WAXED, (Object)false);
    }

    protected Component getTypeName() {
        String id = (this.isWaxed() ? "waxed_" : "") + this.getAge().name().toLowerCase() + "_copper_minecart";
        return Component.translatable((String)this.getType().getDescriptionId().replace("copper_minecart", id));
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult res = this.itemUse(this.level(), player.getItemInHand(hand), player, this.blockPosition());
        if (res.equals((Object)InteractionResult.PASS)) {
            return super.interact(player, hand);
        }
        return res;
    }

    public void tick() {
        if (this.tickCount % 369 == 0 && this.canAge() && this.level().random.nextFloat() < 0.005688889f) {
            this.setAge(WeatheringUtils.nextState(this.getAge()));
        }
        super.tick();
    }

    protected float getBlockSpeedFactor() {
        return super.getBlockSpeedFactor() * this.speedModifier();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.saveWeatheredState(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.loadWeatheredState(tag);
    }

    public static AbstractMinecart createMinecart(Level level, double x, double y, double z, AbstractMinecart.Type type) {
        if (type.equals((Object)AbstractMinecart.Type.CHEST)) {
            return new CopperMinecartChest(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.FURNACE)) {
            return new CopperMinecartFurnace(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.TNT)) {
            return new CopperMinecartTNT(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.SPAWNER)) {
            return new CopperMinecartSpawner(level, x, y, z);
        }
        if (type.equals((Object)AbstractMinecart.Type.HOPPER)) {
            return new CopperMinecartHopper(level, x, y, z);
        }
        return type == AbstractMinecart.Type.COMMAND_BLOCK ? new CopperMinecartCommandBlock(level, x, y, z) : new CopperMinecart(level, x, y, z);
    }
}

