/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.block;

import cy.jdkdigital.everythingcopper.common.block.IWeatheringBlock;
import cy.jdkdigital.everythingcopper.common.block.entity.CopperHopperBlockEntity;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CopperHopper
extends HopperBlock
implements IWeatheringBlock {
    private final WeatheringCopper.WeatherState weatherState;

    public CopperHopper(WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = state;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        this.changeOverTime(blockState, level, blockPos, random);
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return WeatheringCopper.getNext((Block)blockState.getBlock()).isPresent() || super.isRandomlyTicking(blockState);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new CopperHopperBlockEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.isClientSide ? null : CopperHopper.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.COPPER_HOPPER.get()), HopperBlockEntity::pushItemsTick);
    }

    public void changeOverTime(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f = 0.05688889f;
        if (pRandom.nextFloat() < 0.05688889f) {
            this.getNextState(pState, pLevel, pPos, pRandom).ifPresent(newState -> {
                BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
                if (blockEntity instanceof CopperHopperBlockEntity) {
                    CopperHopperBlockEntity hopperBlockEntity = (CopperHopperBlockEntity)blockEntity;
                    CompoundTag tag = hopperBlockEntity.saveWithoutMetadata((HolderLookup.Provider)pLevel.registryAccess());
                    hopperBlockEntity.clearContent();
                    pLevel.setBlockAndUpdate(pPos, newState);
                    pLevel.getBlockEntity(pPos).loadWithComponents(tag, (HolderLookup.Provider)pLevel.registryAccess());
                }
            });
        }
    }
}

