/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888;

import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Director;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Palette;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888ScanlineProcessor;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngIntegrityException;

public abstract class BasicArgb8888Director<ResultT>
implements Argb8888Director<ResultT> {
    protected Argb8888ScanlineProcessor scanlineProcessor;

    @Override
    public void receivePalette(Argb8888Palette palette) {
        this.scanlineProcessor.setPalette(palette);
    }

    @Override
    public void processTransparentPalette(byte[] bytes, int position, int length) throws PngException {
        Argb8888Palette palette = this.scanlineProcessor.getPalette();
        if (null == palette) {
            throw new PngIntegrityException("Received tRNS data but no palette is in place");
        }
        if (length <= 0 || length > palette.size()) {
            throw new PngIntegrityException(String.format("Received tRNS data length is invalid. Should be >1 && < %d but is %d", palette.size(), length));
        }
        for (int i = 0; i < length; ++i) {
            int alpha = 0xFF & bytes[position + i];
            palette.argbArray[i] = alpha << 24 | palette.argbArray[i] & 0xFFFFFF;
        }
    }

    @Override
    public void processTransparentGreyscale(byte k1, byte k0) throws PngException {
        this.scanlineProcessor.processTransparentGreyscale(k1, k0);
    }

    @Override
    public void processTransparentTruecolour(byte r1, byte r0, byte g1, byte g0, byte b1, byte b0) throws PngException {
        this.scanlineProcessor.processTransparentTruecolour(r1, r0, g1, g0, b1, b0);
    }
}

