/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;

public class ReflectionAccessor {
    private ReflectionAccessor() {
        throw new AssertionError();
    }

    protected static MethodHandles.Lookup privateLookup(Class<?> targetClass) {
        try {
            return MethodHandles.privateLookupIn(targetClass, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    protected static MethodHandle findVirtual(MethodHandles.Lookup privateLookup, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            return privateLookup.findVirtual(privateLookup.lookupClass(), methodName, MethodType.methodType(returnType, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    protected static MethodHandle findConstructor(MethodHandles.Lookup privateLookup, Class<?> ... parameterTypes) {
        try {
            return privateLookup.findConstructor(privateLookup.lookupClass(), MethodType.methodType(Void.TYPE, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    protected static MethodHandle findGetter(MethodHandles.Lookup privateLookup, String fieldName, Class<?> fieldType) {
        try {
            return privateLookup.findGetter(privateLookup.lookupClass(), fieldName, fieldType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    protected static VarHandle findField(MethodHandles.Lookup privateLookup, String fieldName, Class<?> fieldType) {
        try {
            return privateLookup.findVarHandle(privateLookup.lookupClass(), fieldName, fieldType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    protected static VarHandle findStaticField(MethodHandles.Lookup privateLookup, String fieldName, Class<?> fieldType) {
        try {
            return privateLookup.findStaticVarHandle(privateLookup.lookupClass(), fieldName, fieldType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }
}

