/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionAccessor;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RendererProxy;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.TextureRenderer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import net.neoforged.fml.earlydisplay.RenderElement;

public class RefRenderElement {
    public static final Class<?> RENDERER_CLASS = ReflectionAccessor.findClass("net.neoforged.fml.earlydisplay.RenderElement$Renderer");
    public static final Class<?> INITIALIZER_CLASS = ReflectionAccessor.findClass("net.neoforged.fml.earlydisplay.RenderElement$Initializer");
    private static final MethodHandles.Lookup lookup = ReflectionAccessor.privateLookup(RenderElement.class);
    private static final MethodHandle constructor = ReflectionAccessor.findConstructor(lookup, INITIALIZER_CLASS);
    private static final VarHandle globalAlpha = ReflectionAccessor.findStaticField(lookup, "globalAlpha", Integer.TYPE);

    private RefRenderElement() {
        throw new AssertionError();
    }

    private static RenderElement constructor(Supplier<?> rendererInitializer) {
        try {
            return constructor.invoke(rendererInitializer);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public static int getGlobalAlpha() {
        return globalAlpha.get();
    }

    public static void setGlobalAlpha(int alpha) {
        globalAlpha.set(alpha);
    }

    public static RenderElement constructor(TextureRenderer renderer) {
        return RefRenderElement.constructor(RefRenderElement.proxyInitializer(renderer));
    }

    public static Supplier<?> proxyInitializer(TextureRenderer textureRenderer) {
        return (Supplier)Proxy.newProxyInstance(INITIALIZER_CLASS.getClassLoader(), new Class[]{INITIALIZER_CLASS}, (proxy, method, args) -> {
            if (method.getName().equals("get")) {
                return RefRenderElement.proxyRenderer(textureRenderer);
            }
            if (!method.canAccess(proxy)) {
                method.setAccessible(true);
            }
            return method.invoke(proxy, args);
        });
    }

    private static Object proxyRenderer(TextureRenderer textureRenderer) {
        return Proxy.newProxyInstance(RENDERER_CLASS.getClassLoader(), new Class[]{RENDERER_CLASS}, (InvocationHandler)new RendererProxy(textureRenderer));
    }
}

