/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionAccessor;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import net.neoforged.fml.earlydisplay.ColourScheme;
import net.neoforged.fml.earlydisplay.DisplayWindow;
import net.neoforged.fml.earlydisplay.EarlyFramebuffer;
import net.neoforged.fml.earlydisplay.RenderElement;
import net.neoforged.fml.earlydisplay.SimpleFont;

public class RefDisplayWindow {
    private static final MethodHandles.Lookup lookup = ReflectionAccessor.privateLookup(DisplayWindow.class);
    private static final MethodHandle initRender = ReflectionAccessor.findVirtual(lookup, "initRender", Void.TYPE, String.class, String.class);
    private static final MethodHandle fbResize = ReflectionAccessor.findVirtual(lookup, "fbResize", Void.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodHandle renderThreadFunc = ReflectionAccessor.findVirtual(lookup, "renderThreadFunc", Void.TYPE, new Class[0]);
    private static final VarHandle loadingOverlay = ReflectionAccessor.findField(lookup, "loadingOverlay", Method.class);
    private static final VarHandle renderScheduler = ReflectionAccessor.findField(lookup, "renderScheduler", ScheduledExecutorService.class);
    private static final VarHandle initializationFuture = ReflectionAccessor.findField(lookup, "initializationFuture", ScheduledFuture.class);
    private static final VarHandle elements = ReflectionAccessor.findField(lookup, "elements", List.class);
    private static final VarHandle window = ReflectionAccessor.findField(lookup, "window", Long.TYPE);
    private static final VarHandle colourScheme = ReflectionAccessor.findField(lookup, "colourScheme", ColourScheme.class);
    private static final VarHandle maximized = ReflectionAccessor.findField(lookup, "maximized", Boolean.TYPE);
    private static final VarHandle fbWidth = ReflectionAccessor.findField(lookup, "fbWidth", Integer.TYPE);
    private static final VarHandle fbHeight = ReflectionAccessor.findField(lookup, "fbHeight", Integer.TYPE);
    private static final VarHandle context = ReflectionAccessor.findField(lookup, "context", RenderElement.DisplayContext.class);
    private static final VarHandle framebuffer = ReflectionAccessor.findField(lookup, "framebuffer", EarlyFramebuffer.class);
    private static final VarHandle framecount = ReflectionAccessor.findField(lookup, "framecount", Integer.TYPE);
    private static final VarHandle font = ReflectionAccessor.findField(lookup, "font", SimpleFont.class);
    private static final VarHandle renderLock = ReflectionAccessor.findField(lookup, "renderLock", Semaphore.class);
    private static final VarHandle windowTick = ReflectionAccessor.findField(lookup, "windowTick", ScheduledFuture.class);
    private static final VarHandle winWidth = ReflectionAccessor.findField(lookup, "winWidth", Integer.TYPE);
    private static final VarHandle winHeight = ReflectionAccessor.findField(lookup, "winHeight", Integer.TYPE);
    private final DisplayWindow target;

    public RefDisplayWindow(DisplayWindow displayWindow) {
        this.target = displayWindow;
    }

    public void setLoadingOverlay(Method overlay) {
        loadingOverlay.set(this.target, overlay);
    }

    public void initRender(String mcVersion, String forgeVersion) {
        try {
            initRender.invoke(this.target, mcVersion, forgeVersion);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public ScheduledExecutorService getRenderScheduler() {
        return renderScheduler.get(this.target);
    }

    public void setRenderScheduler(ScheduledExecutorService service) {
        renderScheduler.set(this.target, service);
    }

    public void setInitializationFuture(ScheduledFuture<?> future) {
        initializationFuture.set(this.target, future);
    }

    public List<RenderElement> getElements() {
        return elements.get(this.target);
    }

    public long getGlWindow() {
        return window.get(this.target);
    }

    public void setColourScheme(ColourScheme scheme) {
        colourScheme.set(this.target, scheme);
    }

    public boolean isMaximized() {
        return maximized.get(this.target);
    }

    public void setFBSize(int width, int height) {
        fbWidth.set(this.target, width);
        fbHeight.set(this.target, height);
    }

    public RenderElement.DisplayContext getContext() {
        return context.get(this.target);
    }

    public void setContext(RenderElement.DisplayContext ctx) {
        context.set(this.target, ctx);
    }

    public void setFrameBuffer(Object fb) {
        framebuffer.set(this.target, fb);
    }

    public EarlyFramebuffer getFramebuffer() {
        return framebuffer.get(this.target);
    }

    public int getFrameCount() {
        return framecount.get(this.target);
    }

    public SimpleFont getFont() {
        return font.get(this.target);
    }

    public int getFbWidth() {
        return fbWidth.get(this.target);
    }

    public int getFbHeight() {
        return fbHeight.get(this.target);
    }

    public Semaphore getRenderLock() {
        return renderLock.get(this.target);
    }

    public void fbResize(long window, int width, int height) {
        try {
            fbResize.invoke(this.target, window, width, height);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public ScheduledFuture<?> getWindowTick() {
        return windowTick.get(this.target);
    }

    public void setWindowTick(ScheduledFuture<?> future) {
        windowTick.set(this.target, future);
    }

    public void renderThreadFunc() {
        try {
            renderThreadFunc.invoke(this.target);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public int getWinWidth() {
        return winWidth.get(this.target);
    }

    public int getWinHeight() {
        return winHeight.get(this.target);
    }
}

