/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.ApngSTBHelper;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.FrameControl;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888BitmapSequence;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngHeader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL13C;

public class ApngTexture {
    private static final Logger LOG = LogManager.getLogger();
    private final FrameControl[] frameControls;
    private final PngHeader header;
    private final int numberOfPlays;
    private final List<Integer> textureIds = new ArrayList<Integer>(1);
    private final List<int[]> textureSizes = new ArrayList<int[]>(1);
    private int currentTexture;
    private int currentXOffset;
    private int currentYOffset;
    private int currentPlay = 0;
    private int currentFrame = 0;

    public ApngTexture(Argb8888BitmapSequence argbSequence) {
        this.header = argbSequence.header;
        this.frameControls = new FrameControl[argbSequence.getAnimationFrames().size()];
        this.numberOfPlays = argbSequence.getAnimationControl().numPlays;
        assert (this.frameControls.length == argbSequence.getAnimationControl().numFrames);
    }

    public boolean loopForever() {
        return this.numberOfPlays == 0;
    }

    public int getFrameCount() {
        return this.frameControls.length;
    }

    public int getTotalWidth() {
        return this.header.width;
    }

    public int getTotalHeight() {
        return this.header.height;
    }

    public int getCurrentTextureId() {
        return this.textureIds.get(this.currentTexture);
    }

    public int[] getCurrentTextureSize() {
        return this.textureSizes.get(this.currentTexture);
    }

    public int getCurrentFrameHeight() {
        return this.frameControls[this.currentFrame].height();
    }

    public int getCurrentFrameWidth() {
        return this.frameControls[this.currentFrame].width();
    }

    public int getCurrentFrameXOffset() {
        return this.frameControls[this.currentFrame].xOffset();
    }

    public int getCurrentFrameYOffset() {
        return this.frameControls[this.currentFrame].yOffset();
    }

    public int getCurrentTextureXOffset() {
        return this.currentXOffset;
    }

    public int getCurrentTextureYOffset() {
        return this.currentYOffset;
    }

    public float getCurrentDelay() {
        return this.frameControls[this.currentFrame].delay();
    }

    private void nextPlay() {
        if (this.numberOfPlays == 0) {
            this.currentFrame = 0;
            this.currentTexture = 0;
            this.currentXOffset = 0;
            this.currentYOffset = 0;
            return;
        }
        if (this.currentPlay + 1 < this.numberOfPlays) {
            ++this.currentPlay;
            this.currentFrame = 0;
            this.currentTexture = 0;
            this.currentXOffset = 0;
            this.currentYOffset = 0;
        }
    }

    private void moveTextureOffsets() {
        this.currentXOffset += this.getCurrentFrameWidth();
        int[] currentTextureSize = this.getCurrentTextureSize();
        if (this.currentXOffset >= currentTextureSize[0]) {
            this.currentXOffset = 0;
            this.currentYOffset += this.getTotalHeight();
        }
        if (this.currentYOffset >= currentTextureSize[1]) {
            this.currentYOffset = 0;
            ++this.currentTexture;
        }
    }

    public void nextFrame() {
        if (this.currentFrame + 1 < this.getFrameCount()) {
            this.moveTextureOffsets();
            ++this.currentFrame;
        } else {
            this.nextPlay();
        }
    }

    private void fillBuffer(ByteBuffer byteBuffer, int startingFrame, int nextStartingFrame, List<Argb8888BitmapSequence.Frame> frames, int textureWidth) {
        int xOffset = 0;
        int yOffset = 0;
        for (int frameIndex = startingFrame; frameIndex < nextStartingFrame; ++frameIndex) {
            int[] data = frames.get((int)frameIndex).bitmap.getPixelArray();
            FrameControl control = this.frameControls[frameIndex];
            int x = 0;
            byteBuffer.position(yOffset * textureWidth * 4 + xOffset * 4);
            for (int i : data) {
                if (x == control.width()) {
                    x = 0;
                    byteBuffer.position(byteBuffer.position() + (textureWidth - control.width() - xOffset) * 4 + xOffset * 4);
                }
                byteBuffer.putInt(ApngSTBHelper.argbToRgba(i));
                ++x;
            }
            if ((xOffset += control.width()) < textureWidth) continue;
            xOffset = 0;
            yOffset += this.header.height;
        }
    }

    public void uploadTextures(List<Argb8888BitmapSequence.Frame> frames) {
        GL13C.glActiveTexture((int)33984);
        ByteBuffer byteBuffer = null;
        assert (frames.size() == this.getFrameCount());
        int startingFrame = 0;
        while (startingFrame < this.getFrameCount()) {
            if (startingFrame > 0) {
                LOG.warn("Creating new texture! APNG frames exceeds hardware maximum texture size of {}x{}. Consider using smaller size or less frames.", (Object)ApngSTBHelper.MAX_TEXTURE_SIZE, (Object)ApngSTBHelper.MAX_TEXTURE_SIZE);
            }
            int lineWidth = 0;
            int totalWidth = 0;
            int totalHeight = 0;
            int nextStartingFrame = this.getFrameCount();
            for (int frameIndex = startingFrame; frameIndex < this.getFrameCount(); ++frameIndex) {
                this.frameControls[frameIndex] = new FrameControl(frames.get((int)frameIndex).control);
                int newWidth = lineWidth + this.frameControls[frameIndex].width();
                if (newWidth >= ApngSTBHelper.MAX_TEXTURE_SIZE) {
                    int newTotalHeight = totalHeight + this.header.height;
                    if (newTotalHeight + this.header.height >= ApngSTBHelper.MAX_TEXTURE_SIZE) {
                        nextStartingFrame = frameIndex;
                        break;
                    }
                    totalHeight = newTotalHeight;
                    totalWidth = Math.max(totalWidth, lineWidth);
                    lineWidth = 0;
                    continue;
                }
                lineWidth = newWidth;
            }
            totalWidth = Math.max(totalWidth, lineWidth);
            byteBuffer = ApngSTBHelper.reallocateWhenRequired(byteBuffer, (totalHeight += this.header.height) * totalWidth * 4);
            this.fillBuffer(byteBuffer, startingFrame, nextStartingFrame, frames, totalWidth);
            byteBuffer.flip();
            int textureId = GL11C.glGenTextures();
            GL11C.glBindTexture((int)3553, (int)textureId);
            this.checkGlError();
            GL11C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11C.glTexImage2D((int)3553, (int)0, (int)6408, (int)totalWidth, (int)totalHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
            this.checkGlError();
            this.textureIds.add(textureId);
            this.textureSizes.add(new int[]{totalWidth, totalHeight});
            startingFrame = nextStartingFrame;
        }
        GL11C.glBindTexture((int)3553, (int)0);
    }

    private void checkGlError() {
        int error = GL11C.glGetError();
        if (error != 0) {
            throw new RuntimeException("OpenGL error: " + error);
        }
    }
}

