/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.BoundsResolver;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ElementPosition;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.StartupProgressBarConfig;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.ProgressBar;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.CSB;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefRenderElement;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefSimpleFont;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.TextureRenderer;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.fml.earlydisplay.ColourScheme;
import net.neoforged.fml.earlydisplay.RenderElement;
import net.neoforged.fml.earlydisplay.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.SimpleFont;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;

public class StartupProgressBar
extends ProgressBar
implements Supplier<RenderElement> {
    private final int lineSpacing;
    private final int descent;
    private final int barCount;
    private final BoundsResolver boundsResolver;

    public StartupProgressBar(SimpleFont font, StartupProgressBarConfig barConfig) {
        super(font);
        RefSimpleFont fontAccessor = new RefSimpleFont(font);
        this.lineSpacing = fontAccessor.lineSpacing();
        this.descent = fontAccessor.descent();
        this.barCount = barConfig.getBarCount();
        barConfig.getPosition().setSizeUnit(ElementPosition.Unit.PIXELS);
        barConfig.getPosition().setWidth(400.0f);
        barConfig.getPosition().setHeight(20.0f);
        this.boundsResolver = barConfig.getPosition();
    }

    private static float[] indeterminateBar(int frame, boolean isActive) {
        if (RefRenderElement.getGlobalAlpha() != 255 || !isActive) {
            return new float[]{0.0f, 1.0f};
        }
        int progress = frame % 100;
        return new float[]{Math.clamp((float)(progress - 2) / 100.0f, 0.0f, 1.0f), Math.clamp((float)(progress + 2) / 100.0f, 0.0f, 1.0f)};
    }

    @Override
    public RenderElement get() {
        return RefRenderElement.constructor(this::render);
    }

    private void render(CSB csb, int frameNumber) {
        List currentProgress = StartupNotificationManager.getCurrentProgress();
        int size = currentProgress.size();
        for (int i = 0; i < this.barCount && i < size; ++i) {
            ProgressMeter pm = (ProgressMeter)currentProgress.get(i);
            this.renderBar(csb, frameNumber, i, pm);
        }
    }

    private void renderBar(CSB csb, int frame, int cnt, ProgressMeter pm) {
        RenderElement.DisplayContext ctx = csb.ctx();
        int[] coords = this.boundsResolver.resolveBounds(400, 20, ctx.scaledWidth(), ctx.scaledHeight());
        int barSpacing = (this.lineSpacing - this.descent + 20) * ctx.scale();
        coords[1] = coords[1] + cnt * barSpacing;
        coords[3] = coords[3] + cnt * barSpacing;
        int alpha = 255;
        int colour = ColourScheme.BLACK.foreground().packedint(255);
        TextureRenderer textureRenderer = pm.steps() == 0 ? StartupProgressBar.progressBar(coords, f -> colour, f -> StartupProgressBar.indeterminateBar(f, cnt == 0)) : StartupProgressBar.progressBar(coords, f -> colour, f -> new float[]{0.0f, pm.progress()});
        textureRenderer.accept(csb, frame);
        this.renderText(this.text(coords[0], coords[3], pm.label().getText(), colour), csb);
    }

    public static interface TextGenerator {
        public void accept(SimpleBufferBuilder var1, SimpleFont var2, RenderElement.DisplayContext var3);
    }
}

