/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.treetap.TreeTap;
import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SapCollectorBlock
extends BaseEntityBlock {
    public static final MapCodec<SapCollectorBlock> CODEC = SapCollectorBlock.simpleCodec(SapCollectorBlock::new);
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.join((VoxelShape)Block.box((double)2.5, (double)4.0, (double)5.0, (double)13.5, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)3.5, (double)5.0, (double)6.0, (double)12.5, (double)14.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST));
            this.put(Direction.SOUTH, Shapes.join((VoxelShape)Block.box((double)2.5, (double)4.0, (double)0.0, (double)13.5, (double)14.0, (double)11.0), (VoxelShape)Block.box((double)3.5, (double)5.0, (double)1.0, (double)12.5, (double)14.0, (double)10.0), (BooleanOp)BooleanOp.ONLY_FIRST));
            this.put(Direction.WEST, Shapes.join((VoxelShape)Block.box((double)5.0, (double)4.0, (double)2.5, (double)16.0, (double)14.0, (double)13.5), (VoxelShape)Block.box((double)6.0, (double)5.0, (double)3.5, (double)15.0, (double)14.0, (double)12.5), (BooleanOp)BooleanOp.ONLY_FIRST));
            this.put(Direction.EAST, Shapes.join((VoxelShape)Block.box((double)0.0, (double)4.0, (double)2.5, (double)11.0, (double)14.0, (double)13.5), (VoxelShape)Block.box((double)1.0, (double)5.0, (double)3.5, (double)10.0, (double)14.0, (double)12.5), (BooleanOp)BooleanOp.ONLY_FIRST));
        }
    };

    public SapCollectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SapCollectorBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)HorizontalDirectionalBlock.FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.relative(Direction.UP)).is((Block)TreeTap.TAP.get());
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 4);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        TagKey<Item> tag = state.is((Block)TreeTap.WOODEN_SAP_COLLECTOR.get()) ? TreeTap.WOODEN_BUCKETS : TreeTap.METAL_BUCKETS;
        Iterator bucketItem = BuiltInRegistries.ITEM.getTagOrEmpty(tag).iterator();
        return bucketItem.hasNext() ? new ItemStack((Holder)bucketItem.next()) : ItemStack.EMPTY;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof SapCollectorBlockEntity) {
            SapCollectorBlockEntity sapCollectorBlock = (SapCollectorBlockEntity)blockEntity;
            if (sapCollectorBlock.currentRecipe != null && sapCollectorBlock.progress >= ((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).processingTime) {
                boolean hasCorrectItem;
                boolean bl = hasCorrectItem = ((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).harvestItem.isEmpty() && pStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).harvestItem, (ItemStack)pStack);
                if (hasCorrectItem) {
                    if (!pLevel.isClientSide) {
                        if (((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).collectBucket) {
                            pPlayer.setItemInHand(pHand, ((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).getResultItem(pState));
                            pLevel.playSound(pPlayer, pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS);
                        } else {
                            SapCollectorBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).getResultItem(pState));
                            pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                        }
                        pPlayer.swing(pHand);
                        if (((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).collectBucket) {
                            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
                        }
                        if (!((TapExtractRecipe)sapCollectorBlock.currentRecipe.value()).harvestItem.isEmpty() && !pPlayer.isCreative()) {
                            pStack.shrink(1);
                        }
                        sapCollectorBlock.progress = 0;
                        pLevel.sendBlockUpdated(pPos, pState, pState, 2);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }
}

